process.env.NODE_ENV = 'test';
var chai = require('chai');
var chaiHttp = require('chai-http');
var server = require('../index');
var should = chai.should();
const authenticate = require('./test_config');

let v1, v2, extend;
chai.use(chaiHttp);

/*
v1 =
    {
        "patient": "7",
        "hospitalAdmissionStatus": "3",
        "serviceConnected": "0",
        "generalComments": "THIS IS A COMMENT",
        "princAnesthetist": "103",
        "anesthesiologistSupvr": "102",
        "anesthesiaTechnique": [],
        "plannedPostopCare": "10",
        "otherPostopDiags": [],
        "principalProcedure": "BLM GENE",
        "plannedPrincOpProcCPT": "81209",
        "procedureLaterality": "1",
        "caseScheduleType": "EL",
        "dateOfOperation": "2017-10-10T18:09:00.000Z",
        "orRoom": "1",
        "reqAneTechnique": "L",
        "surgeryPosition": [
            {"position":20, "date":"2017-10-01T18:09:03.000Z"},
            {"position":5, "date":"2017-10-01T18:09:08.000Z"},
            {"position":6, "date":"2017-10-01T18:09:17.000Z"}],
        "surgerySpecialty": "1",
        "primarySurgeon": "12",
        "firstAsst": "68",
        "secondAsst": "69",
        "attendingSurgeon": "16",
        "reqFrozSect": "N",
        "intraoperativeXrays": "N",
        "reqPhoto": "N",
        "requestBloodAvailability": "N",
        "preAdmissionTesting": "N",
        "specialEquipment": [3,2],
        "bloodTypeXmatch": "N",
        "scheduledStartTime": "2017-10-14T18:00:00.000Z",
        "scheduledEndTime": "2017-10-14T19:00:00.000Z",
        "surgeryScheduler": "54"
    };
v2 = {
    "patient": "9",
    "hospitalAdmissionStatus": "3",
    "serviceConnected": "0",
    "generalComments": "THIS IS A COMMENT",
    "princAnesthetist": "103",
    "anesthesiologistSupvr": "102",
    "anesthesiaTechnique": [],
    "plannedPostopCare": "10",
    "otherPostopDiags": [],
    "principalProcedure": "BLM GENE",
    "plannedPrincOpProcCPT": "81209",
    "procedureLaterality": "1",
    "caseScheduleType": "EL",
    "dateOfOperation": "2017-10-10T18:09:00.000Z",
    "orRoom": "1",
    "reqAneTechnique": "L",
    "surgeryPosition": [
        {"position":20, "date":"2017-10-01T18:09:03.000Z"},
        {"position":5, "date":"2017-10-01T18:09:08.000Z"},
        {"position":6, "date":"2017-10-01T18:09:17.000Z"}],
    "surgerySpecialty": "1",
    "primarySurgeon": "12",
    "firstAsst": "68",
    "secondAsst": "69",
    "attendingSurgeon": "16",
    "reqFrozSect": "N",
    "intraoperativeXrays": "N",
    "reqPhoto": "N",
    "requestBloodAvailability": "N",
    "preAdmissionTesting": "N",
    "specialEquipment": [3,2],
    "bloodTypeXmatch": "N",
    "scheduledStartTime": "2017-10-14T19:00:00.000Z",
    "scheduledEndTime": "2017-10-14T19:45:00.000Z",
    "surgeryScheduler": "54"
};
*/

describe('Manage Surgery cases', function() {
    this.timeout(0);


    // GET ALL
    it('should retrieve all extended cases, GET - /v1/cases/extend/', function(done){
        authenticate(function(token){
            "use strict";
            chai.request(server)
                .get('/v1/cases/extend/')
                .set('Authorization', token)
                .send(extend)
                .end(function(err,response){
                    response.should.have.status(200);
                    response.should.be.json;
                    response.body.should.be.a('array');
                    done();
                });
        })
    });

    /*
    before(function(done){
        authenticate(function(token){
            console.log("BEFORE");
            console.log(v1);
            chai.request(server)
                .post('/v1/cases')
                .set('Authorization', token)
                .send(v1)
                .end(function(err,response){
                    v1.ien = response.body.ien;
                    console.log(v1.ien);
                    extend = {vistaId: v1.ien, estimatedOverTime: 60};
                    console.log(extend);
                    chai.request(server)
                        .post('/v1/cases')
                        .set('Authorization', token)
                        .send(v2)
                        .end(function(err,response2){
                            v2.ien = response2.body.ien;
                            done();
                        })
                });
        });

    });

    after(function(done){
        authenticate(function(token){
            "use strict";
            chai.request(server)
                .delete('/v1/cases/' + v1.ien)
                .set('Authorization', token)
                .set('Content-Type', 'application/json')
                .end(function(err,response){
                    v1.ien = response.ien;
                    // done();
                });
            chai.request(server)
                .post('/v1/cases')
                .set('Authorization', token)
                .set('Content-Type', 'application/json')
                .send(v2)
                .end(function(err,response){
                    v2.ien = response.ien;
                    // done();
                })
        })
    });

    // POST
    it('should extend case v1, POST - /v1/cases/extend/', function(done){
        authenticate(function(token){
            "use strict";
            chai.request(server)
                .post('/v1/cases/extend')
                .set('Authorization', token)
                .send(extend)
                .end(function(err,response){
                    response.should.have.status(200);
                    response.should.be.json;
                    response.body.should.have.property("vistaId");
                    response.body.should.have.property("estimatedOverTime");
                    done();
                });
        })
    });

    // EDIT
    it('should updated extended case estimatedOverTime v1, PUT - /v1/cases/extend/:id', function(done){
        authenticate(function(token){

            extend.estimatedOverTime = 90;
            console.log("TESTING PUT");
            console.log(v1.ien);
            chai.request(server)
                .put('/v1/cases/extend/' + v1.ien)
                .set('Authorization', token)
                .send(extend)
                .end(function(err,response){
                    response.should.have.status(200);
                    response.should.be.json;
                    response.body.should.have.property("vistaId");
                    response.body.should.have.property("estimatedOverTime");
                    done();
                });
        })
    });

    // GET
    it('should retrieve an extended case for specific vista id, GET - /v1/cases/extend/:id', function(done){
        authenticate(function(token){
            "use strict";
            extend.estimatedOverTime = 90;
            chai.request(server)
                .get('/v1/cases/extend/' + v1.ien)
                .set('Authorization', token)
                .send(extend)
                .end(function(err,response){
                    response.should.have.status(200);
                    response.should.be.json;
                    response.body.should.have.property("vistaId");
                    response.body.should.have.property("estimatedOverTime");
                    done();
                });
        })
    });


    // GET
    it('delete an extended case for specific vista id, DELETE - /v1/cases/extend/:id', function(done){
        authenticate(function(token){
            "use strict";
            chai.request(server)
                .delete('/v1/cases/extend/' + v1.ien)
                .set('Authorization', token)
                .send(extend)
                .end(function(err,response){
                    response.should.have.status(200);
                    response.should.be.json;
                    done();
                });
        })
    });
    */

});