process.env.NODE_ENV = 'test';
var chai = require('chai');
var chaiHttp = require('chai-http');
var server = require('../index');
var should = chai.should();
const authenticate = require('./test_config');

chai.use(chaiHttp);

let criteria = {
    "cptCode": "11046",
    "surgeon": 2,
    "specialty": 1
}

describe('Tests the management of CPT configuration', function() {
    this.timeout(0);

    it('should get a list of all CPTConfig, GET  - /v1/cpt/config', function(done){
        authenticate(function(token){
            "use strict";
            chai.request(server)
                .get('/v1/cpt/config/')
                .set('Authorization', token)
                .end(function(err,response){
                    response.should.have.status(200);
                    response.should.be.json;
                    response.body.should.be.a('array');
                    done();
                });
        })
    });

    it('should search for case durations of an existing CPTConfig for the specified search criteria, POST - /v1/cpt/config/duration/search', function(done){
        authenticate(function(token){
            "use strict";
            chai.request(server)
                .post('/v1/cpt/config/duration/search')
                .set('Authorization', token)
                .send(criteria)
                .end(function(err,response){
                    response.should.have.status(200);
                    response.should.be.json;
                    done();
                });
        })
    });

    /*
    it('should create a new CPTConfig POST - /v1/cpt/config', function(done){
        authenticate(function(token){
            "use strict";
            chai.request(server)
                .post('/v1/cpt/config/')
                .set('Authorization', token)
                .send({
                    "cptCode" : "99999",
                    "siteDuration" : 30
                })
                .end(function(err,response){
                    response.should.have.status(200);
                    response.should.be.json;
                    response.body.should.be.a('object');
                    response.body.should.have.property('_id');
                    console.log(response.body._id);
                    done();
                });
        })
    });

    it('should update existing CPTConfig for the specified id: 99999  PUT - /v1/cpt/config', function(done){
        authenticate(function(token){
            "use strict";
            chai.request(server)
                .put('/v1/cpt/config/99999')
                .set('Authorization', token)
                .send({
                    "cptCode" : "99999",
                    "siteDuration" : 100
                })
                .end(function(err,response){
                    response.should.have.status(200);
                    done();
                });
        })
    });

    it('should get a CPTConfig by a cptCode: 99999, GET - /v1/cpt/config/99999', function(done){
        authenticate(function(token){
            "use strict";
            chai.request(server)
                .get('/v1/cpt/config/99999')
                .set('Authorization', token)
                .end(function(err,response){
                    response.should.have.status(200);
                    response.should.be.json;
                    response.body.should.be.a('object');
                    response.body.should.have.property('_id');
                    response.body.should.have.property('cptCode');
                    response.body.should.have.property('siteDuration');
                    done();
                });
        })
    });

    it('should search for a CPTConfig POST by criteria, POST - /v1/cpt/config/search', function(done){
        authenticate(function(token){
            "use strict";
            chai.request(server)
                .post('/v1/cpt/config/search/')
                .set('Authorization', token)
                .send({
                    "cptCode" : "99999"
                })
                .end(function(err,response){
                    response.should.have.status(200);
                    response.should.be.json;
                    response.body.should.be.a('array');
                    done();
                });
        })
    });

    it('should get surgery duration based on CPT code,  GET - /v1/cpt/config/duration/99999', function(done){
        authenticate(function(token){
            "use strict";
            chai.request(server)
                .get('/v1/cpt/config/duration/99999')
                .set('Authorization', token)
                .end(function(err,response){
                    console.log(response);
                    response.should.have.status(200);
                    response.should.be.json;
                    done();
                });
        })
    });

    it('should delete an existing CPTConfig for the specified id: 99999, DELETE  - /v1/cpt/config', function(done){
        authenticate(function(token){
            "use strict";
            chai.request(server)
                .delete('/v1/cpt/config/99999')
                .set('Authorization', token)
                .end(function(err,response){
                    response.should.have.status(200);
                    response.should.be.json;
                    done();
                });
        })
    });
    */

});
