process.env.NODE_ENV = 'test';
var chai = require('chai');
var chaiHttp = require('chai-http');
var server = require('../index');
var should = chai.should();
const authenticate = require('./test_config');

chai.use(chaiHttp);


describe('v1 Config', function() {
  it('should list ALL configs on /v1/config GET', function(done){
	  authenticate(function(token) {
		  chai.request(server)
			  .get('/v1/config')
              .set('Authorization', token)
			  .end(function (err, res) {
				  res.should.have.status(200);
				  res.should.be.json;
				  res.body.should.be.a('array');
				  done();
			  })
	  });
  });
  
  it('should add a SINGLE config on /v1/config POST', function(done) {
      authenticate(function (token) {
          chai.request(server)
              .post('/v1/config')
              .set('Authorization', token)
              .send({
                  "VASQIPeligibility": ["item1", "item2"],
                  "AssessmentEligibilityCategory": ["item1", "item2"],
                  "ComplexityCategory": ["item1", "item2"],
                  "ComplexityLevel": ["item1", "item2"],
                  "ProcedureCode": ["item1", "item2"]
              })
              .end(function (err, res) {
                  res.should.have.status(200);
                  res.should.be.json;
                  res.body.should.be.a('object');
                  res.body.should.have.property('VASQIPeligibility');
                  res.body.should.have.property('AssessmentEligibilityCategory');
                  res.body.should.have.property('ComplexityCategory');
                  res.body.should.have.property('ComplexityLevel');
                  res.body.should.have.property('ProcedureCode');
              });
          done();
      })
  });

  it('should delete ALL configs on /v1/config DELETE', function(done){
	authenticate(function(token){
		"use strict";
        chai.request(server)
            .delete('/v1/config')
			.set('Authorization', token)
            .end(function(error, response){
                response.should.have.status(200);
                response.should.be.json;
                response.body.should.be.a('object');
                response.body.should.have.property('ok');
                response.body.should.have.property('n');
                done();
            });
	})
  });
});