process.env.NODE_ENV = 'test';
var chai = require('chai');
var chaiHttp = require('chai-http');
var server = require('../index');
var should = chai.should();
const authenticate = require('./test_config');

chai.use(chaiHttp);

let testData = {
    "patient": "7",
    "hospitalAdmissionStatus": "3",
    "serviceConnected": "0",
    "generalComments": "THIS IS A COMMENT",
    "princAnesthetist": "103",
    "anesthesiologistSupvr": "102",
    "anesthesiaTechnique": [],
    "plannedPostopCare": "10",
    "otherPostopDiags": [],
    "principalProcedure": "BLM GENE",
    "plannedPrincOpProcCPT": "81209",
    "procedureLaterality": "1",
    "caseScheduleType": "EL",
    "dateOfOperation": "2017-10-10T18:09:00.000Z",
    "orRoom": "1",
    "reqAneTechnique": "L",
    "surgeryPosition": [
        {"position":20, "date":"2017-10-01T18:09:03.000Z"},
        {"position":5, "date":"2017-10-01T18:09:08.000Z"},
        {"position":6, "date":"2017-10-01T18:09:17.000Z"}],
    "surgerySpecialty": "1",
    "primarySurgeon": "12",
    "firstAsst": "68",
    "secondAsst": "69",
    "attendingSurgeon": "16",
    "reqFrozSect": "N",
    "intraoperativeXrays": "N",
    "reqPhoto": "N",
    "requestBloodAvailability": "N",
    "preAdmissionTesting": "N",
    "specialEquipment": [3,2],
    "bloodTypeXmatch": "N",
    "endTime": "2017-10-10T18:09:00.000Z",
    "startTime": "2017-10-10T18:09:30.000Z",
    "surgeryScheduler": "54"
}
describe('Manage Surgery cases /v1/cases/', function() {
    this.timeout(0);

    it('should get a list of cases', function(done){
        authenticate(function(token){
            "use strict";
            chai.request(server)
                .get('/v1/cases/')
                .set('Authorization', token)
                .end(function(err,response){
                    response.should.have.status(200);
                    response.should.be.json;
                    response.body.should.be.a('array');
                    done();
                });
        })
    });

    /*
    it('should get a case for caseId = 5', function(done){
        authenticate(function(token){
            "use strict";
            chai.request(server)
                .get('/v1/cases/5')
                .set('Authorization', token)
                .end(function(err,response){
                    response.should.have.status(200);
                    response.should.be.json;
                    done();
                });
        })
    });

    it('should cancel a case given a specified ID', function(done){
        authenticate(function(token){
            "use strict";
            chai.request(server)
                .put('/v1/cases/cancel/44')
                .send({
                    "cancelReason": "some reason",
                    "cancelComments": "need to reschedule",
                    "cancelledBy": "some_user"
                })
                .set('Authorization', token)
                .set('Content-Type', 'application/json')
                .end(function(err,response){
                    //response.should.have.status(200);
                    //response.should.be.json;
                    done();
                });
        })
    });

    it('should reschedule a case for the new specified date/time', function(done){
        authenticate(function(token){
            "use strict";
            chai.request(server)
                .put('/v1/cases/reschedule/44')
                .set('Authorization', token)
                .set('Content-Type', 'application/json')
                .send({
                    "procedureDate": "2017-04-01",
                    "reschDate": "2017-04-20",
                    "cancelComments": "family emergency"
                })
                .end(function(err,response){
                    response.should.have.status(200);
                    response.should.be.json;
                    done();
                });
        })
    });

    it('should create a new case', function(done){
        authenticate(function(token){
            "use strict";
            chai.request(server)
                .post('/v1/cases')
                .set('Authorization', token)
                .set('Content-Type', 'application/json')
                .send(testData)
                .end(function(err,response){
                    // response.should.have.status(200);
                    // response.should.be.json;
                    // response.body.should.have.property('ien');
                    done();
                });
        })
    });

/*
    it('should edit an existing or case', function(done){
        authenticate(function(token){
            "use strict";
            chai.request(server)
                .put('/v1/cases/or')
                .set('Authorization', token)
                .set('Content-Type', 'application/json')
                .end(function(err,response){
                    response.should.have.status(200);
                    response.should.be.json;
                    done();
                });
        })
    });

    it('should edit an existing non-or case', function(done){
        authenticate(function(token){
            "use strict";
            chai.request(server)
                .put('/v1/cases/nor')
                .set('Authorization', token)
                .set('Content-Type', 'application/json')
                .end(function(err,response){
                    response.should.have.status(200);
                    response.should.be.json;
                    done();
                });
        })
    });

    it('should convert an existing case to a requested case', function(done){
        authenticate(function(token){
            "use strict";
            chai.request(server)
                .put('/v1/cases/convert/requested')
                .set('Authorization', token)
                .set('Content-Type', 'application/json')
                .end(function(err,response){
                    response.should.have.status(200);
                    response.should.be.json;
                    done();
                });
        })
    });

    it('should convert an existing case to a scheduled case', function(done){
        authenticate(function(token){
            "use strict";
            chai.request(server)
                .put('/v1/cases/convert/scheduled')
                .set('Authorization', token)
                .set('Content-Type', 'application/json')
                .end(function(err,response){
                    response.should.have.status(200);
                    response.should.be.json;
                    done();
                });
        })
    });
    */
});
