'use strict';

require('dotenv').config();

const express = require('express');
const mongoose = require('mongoose');

const port = process.env.PORT || 7000;

const app = express();
module.exports = app;

// load all models
require('./app/model/audit');
require('./app/model/config');
require('./app/model/site');
require('./app/model/role');
require('./app/model/templateCase');
require('./app/model/specialtyRoomTypeMapping');
require('./app/model/vistaSetField');
require('./app/model/sslqi');
require('./app/model/sslqiReservation');
require('./app/model/sslqiReleaseRequest');
require('./app/model/cptConfig');
require('./app/model/extendedCase');
require('./app/model/nameDescription');
require('./app/model/provider');
require('./app/model/notification');

// load configuration for express
require('./config/express')(app);

// load all routes
require('./default_routes')(app);



// connect to mongo, start server
connect()
  .on('error', console.log)
  .on('disconnected', connect)
  .once('open', listen);


function listen () {
  if (app.get('env') === 'test')
  {
    console.log('Express app started in test mode on port ' + port);
    return;
  }
  app.listen(port);
  console.log('Express app started on port ' + port);
}

function connect () {
  var options = { server: { socketOptions: { keepAlive: 1 } } };
  return mongoose.connect(process.env.DB_HOST, options).connection;
}
