'use strict';
const vistaconfig = require("../../../lib/rpcvista/vistaconfig");
const vista = require("../../../lib/rpcvista/vista_surgery_services");
const auth = require("../authenticate");
const Case = require("../../model/case");
const caseService = require("./case");

/************************************
 *        Placeholder Cases         *
 ************************************/

exports.getWaitingListObjects = function(loginOptions, patientID, callback) {
    console.log("Entering getWaitingListObjects ...");
    auth.buildConfiguration(loginOptions, function(configuration){
        vista.callRpc(
            vistaconfig.logger,
            configuration,
            'SR GET PLACE HOLDER CASES',
            patientID,
            function(error, result){
                if (error){
                    console.log("Error:" + error);
                    callback(error, null);
                }
                else if(result instanceof Error || result === undefined){
                    console.log('ERROR');
                    callback(result, null);
                }else{
                    console.log('***found placeholder cases for patient');
                    console.log(result);
                    /*
                     H1 SURGICAL SPECIALTY TEXT
                     H2 SURGICAL SPECIALTY NUMBER
                     .01  PATIENT NAME
                     1  OPERATION
                     2  DATE ENTERED ON LIST
                     3  REFERRING PHYSICIAN
                     4  COMMENTS
                     5  TENTATIVE ADMISSION DATE
                     6  TENTATIVE DATE OF OPERATION
                     16  SERVICE CONNECTED
                     17  AGENT ORANGE EXPOSURE
                     18  IONIZING RADIATION EXPOSURE
                     19  SOUTHWEST ASIA CONDITIONS
                     20  CLASSIFICATION ENTERED (Y/N)
                     21  MILITARY SEXUAL TRAUMA
                     22  HEAD AND/OR NECK CANCER
                     23  COMBAT VET
                     24  PROJ 112/SHAD
                     */

                    let resultList = result.split("\r");
                    let caseList = [];
                    if (resultList instanceof Array){
                        var rowSplit, surgeonSplit, vistaCase, caseStartDateTime, caseEndDateTime;
                        for (var i = 0, x = resultList.length - 1; i < x; i++){
                            if (resultList[i] === undefined || resultList[i] === null || resultList[i] === ''){
                                console.log('empty row - split tail entry: ' + (i == x));
                            }
                            else {
                                rowSplit = resultList[i].split('^');
                                if (resultList != undefined){
                                    surgeonSplit = rowSplit[4].split(';');
                                }

                                caseStartDateTime = vista.convertFromVistaDate(rowSplit[3] + '.' + rowSplit[6].replace(':',''));
                                caseEndDateTime = vista.convertFromVistaDate(rowSplit[3] + '.' + rowSplit[7].replace(':',''));

                                vistaCase = {
                                    ien: rowSplit[1],
                                    description: rowSplit[2],
                                    dateOfOperation: caseStartDateTime,
                                    caseDuration: (caseEndDateTime - caseStartDateTime)/1000/60,
                                    surgeon: {
                                        id: surgeonSplit[0],
                                        name: surgeonSplit[1]
                                    },
                                    orRoom: rowSplit[0]
                                };
                                caseList[i] = vistaCase;
                            }
                        }
                    }
                }
            }
        );
    });
};