/**
 * SSLQIReservation Service
 * @author atignola
 */
'use strict';
const mongoose = require('mongoose');
const SSLQIReservation = mongoose.model('SSLQIReservation');


/**
 * Create new SSLQI reservation
 * @param data
 * @param callback
 */
exports.create = function(data, callback){
    const reservation = new SSLQIReservation(data);
    // save function, will create a new record in the card collection in mongo
    reservation.save(function(err){
        if(err) {
            console.log(err);
            callback(err, null);
        }
        else{
            callback(null, reservation);
        }
    });
}

/**
 * Edit existing SSLQI reservation
 * @param data
 * @param callback
 */
exports.edit = function(id, data, callback) {
    console.log("Entering edit ...");
    if (data !== undefined && data !== null && Object.keys(data).length !== 0) {

        SSLQIReservation.findOne({_id: id}, function (err, existingDoc) {
            if (err) {
                callback(err, null);
            }
            else if (existingDoc === null || existingDoc === undefined) {
                callback("Entry does not exist.", null);
            }
            else {
                // Update SSLQI reservation
                for (var property in data) {
                    if (property !== "_id") {
                        existingDoc[property] = data[property];
                    }
                }
                existingDoc.save(function (err) {
                    if (err) {
                        console.log(err);
                        callback(err, null);
                    }
                    else {
                        console.log("SUCCESS");
                        callback(null, existingDoc);
                    }
                })
            }

        });
    }
    else {
        callback("No data provided.", null);
    }
}

/**
 * Get the list of reservations for SSLQI
 * @param callback
 */
exports.getAll = function(callback){
    SSLQIReservation.find({}, function(err, docs){
        if(!err){
            callback(null, docs);
        } else {
            callback(err, null);
        }
    });
}

/**
 * Get SSLQI reservation by id
 * @param callback
 */
exports.getById = function(id, callback){
    SSLQIReservation.findOne({_id:id}, function(err, docs){
        if(!err){
            callback(null, docs);
        } else {
            callback(err, null);
        }
    });
}

/**
 * Retrieve by search criteria
 * @param criteria
 * @param callback
 */
exports.search = function (criteria, callback) {
    console.log("Entering search ...");
    let vistaId = criteria.vistaId || undefined;
    let classification = criteria.classification || undefined;
    let caseId = criteria.caseId|| undefined;
    let requester = criteria.requester || undefined;
    let room = criteria.room || undefined;
    let query = {};

    /* TODO - should this be restricted??
    if ((vistaId !== undefined && classification === undefined)
        || (vistaId === undefined && classification !== undefined)){
        callback("Error: VistA ID and classification are unique index, both must be specified.", null);
    }*/

    // Build query
    if (vistaId !== undefined){
        query["vistaId"] = vistaId;
    }
    if (classification !== undefined){
        query["classification"] = classification;
    }
    if (caseId !== undefined) {
        query["caseId"] = caseId;
    }
    if (requester !== undefined) {
        query["requester"] = requester;
    }
    if (room !== undefined) {
        query["room"] = room;
    }

    // Execute query
    SSLQIReservation.find(query, function (err, data) {
        if (!err) {
            callback(null, data);
        } else {
            // TODO Check dates
            console.log('error');
            callback(err, null);
        }
    });
};

/**
 Delete SSLQIReservation by ID
 @param id
 @param callback
 */
exports.remove = function(id, callback){
    SSLQIReservation.findOne({_id:id}, 'role', function(err, data){
        if (data !== null && data !== undefined && data["role"] !== "ALL" ){
            SSLQIReservation.remove({_id:id},function(err, removed){
                if(!err){callback(null, removed);}
                else {callback(err, null);}
            });
        }
        else{
            callback("Error: No data for the specified ID exists.", null);
        }

    });

}

