'use strict';
const _ = require('underscore');
const mongoose = require('mongoose');
const SSLQI = mongoose.model('SSLQI');

const listService = require("../../services/rpc/list");

/**
 * Get default room based on criteria
 * @param loginOptions
 * @param criteria
 * @param callback
 */
function getSSLQIForCriteria(loginOptions, criteria, callback) {
    console.log("Entering getSSLQIForCriteria ...");
    let vistaId = criteria.vistaId || undefined,
        itemCategory = criteria.itemCategory || undefined,
        itemType = criteria.itemType || undefined,
        itemSpecialtyType = criteria.itemSpecialtyType || undefined,
        item = criteria.item || undefined,
        inventoryNumber = criteria.inventoryNumber || undefined,
        classification = criteria.classification || undefined,
        itemLocation = criteria.itemLocation || undefined,
        itemStatus = criteria.itemStatus || undefined,
        itemTypeQuality = criteria.itemTypeQuality || undefined,
        size = criteria.size || undefined,
        itemUsage = criteria.itemUsage || undefined,
        specialty = criteria.specialty || undefined,
        manufacturer = criteria.manufacturer || undefined,
        vendor = criteria.vendor || undefined,
        model = criteria.model || undefined,
        serialNumber = criteria.serialNumber || undefined,
        mobilityIndicator = criteria.mobilityIndicator || undefined,
        roomNumber = criteria.roomNumber || undefined,
        reqRoomSize = criteria.reqRoomSize || undefined,
        shields = criteria.shields || undefined,
        environmentalInformation = criteria.environmentalInformation || undefined,
        availability = criteria.availability || undefined,
        blockedTimes = criteria.blockedTimes || undefined,
        attributeTags = criteria.attributeTags || undefined,
        limiations = criteria.limiations || undefined,
        safetyMeasureThresholdMin = criteria.safetyMeasureThresholdMin || undefined,
        safetyMeasureThresholdMax = criteria.safetyMeasureThresholdMax || undefined,
        comments = criteria.comments || undefined,
        poc = criteria.poc || undefined;

    // Check for empty array
    if (specialty !== undefined && (Object.prototype.toString.call(specialty) == '[object Array]'&& specialty.length === 0)){
        specialty = undefined;
    }

    let query = {};

    // Build query
    if (vistaId !== undefined) {
        query["vistaId"] = vistaId;
    }
    if (itemCategory !== undefined) {
        query["itemCategory"] = itemCategory;
    }
    if (itemType !== undefined) {
        query["itemType"] = itemType;
    }
    if (itemSpecialtyType !== undefined) {
        query["itemSpecialtyType"] = itemSpecialtyType;
    }
    if (item !== undefined) {
        query["item"] = item;
    }
    if (inventoryNumber !== undefined) {
        query["inventoryNumber"] = inventoryNumber;
    }
    if (classification !== undefined) {
        query["classification"] = classification;
    }
    if (itemLocation !== undefined) {
        query["itemLocation"] = itemLocation;
    }
    if (itemStatus !== undefined) {
        query["itemStatus"] = itemStatus;
    }
    if (itemTypeQuality !== undefined) {
        query["itemTypeQuantity"] = itemTypeQuality;
    }
    if (size !== undefined) {
        query["size"] = size;
    }
    if (itemUsage !== undefined) {
        query["itemUsage"] = itemUsage;
    }
    if (specialty !== undefined) {
        query["specialty"] = specialty;
    }
    if (manufacturer !== undefined) {
        query["manufacturer"] = manufacturer;
    }
    if (vendor !== undefined) {
        query["vendor"] = vendor;
    }
    if (model !== undefined) {
        query["model"] = model;
    }
    if (serialNumber !== undefined) {
        query["serialNumber"] = serialNumber;
    }
    if (mobilityIndicator !== undefined) {
        query["mobilityIndicator"] = mobilityIndicator;
    }
    if (roomNumber !== undefined) {
        query["roomNumber"] = roomNumber;
    }
    if (reqRoomSize !== undefined) {
        query["reqRoomSize"] = reqRoomSize;
    }
    if (shields !== undefined) {
        query["shields"] = shields;
    }
    if (environmentalInformation !== undefined) {
        query["environmentalInformation"] = environmentalInformation;
    }
    if (availability !== undefined) {
        query["availability"] = availability;
    }
    if (blockedTimes !== undefined) {
        query["blockedTimes"] = blockedTimes;
    }
    if (attributeTags !== undefined) {
        query["attributeTags"] = attributeTags;
    }
    if (limiations !== undefined) {
        query["limiations"] = limiations;
    }
    if (safetyMeasureThresholdMin !== undefined) {
        query["safetyMeasureThresholdMin"] = safetyMeasureThresholdMin;
    }
    if (safetyMeasureThresholdMax !== undefined) {
        query["safetyMeasureThresholdMax"] = safetyMeasureThresholdMax;
    }
    if (comments !== undefined) {
        query["comments"] = comments;
    }
    if (poc !== undefined) {
        query["poc"] = poc;
    }

    // Get VistA SSLQI
    let filteredVista = [];
    getAllVistaSSLQI(loginOptions, function (vErr, vistaData) {
        if (vistaData !== undefined && vistaData !== null && vistaData.length > 0) {

            console.log("QUERY:");
            console.log(query);
            let i, x, temp, add;
            for (i = 0, x = vistaData.length; i < x; i++) {
                add = true;
                temp = vistaData[i];
                for (let property in query) {
                    console.log(property);
                    // Does vistaData have property
                    // Does vistaData property match search criteria
                    console.log(comparePropertiesForSearch(temp[property], query[property]));
                    add = (query[property] === undefined || comparePropertiesForSearch(temp[property], query[property]));

                    // If add is false, break out of loop
                    if (!add) {
                        console.log("not adding because of: " + property);
                        break;
                    }
                    else{console.log("looks good: " + property);}
                }

                if (add) {
                    filteredVista.push(temp);
                }
            }
        }
        // Execute query
        SSLQI.find(query, function (mErr, data) {
            if (mErr) {
                console.log('Error: ' + mErr);
                callback(mErr);
            } else {

                mergeSSLQI(filteredVista, data, function (err, result) {
                    if (err) {
                        console.log("Error: " + err);
                        callback(err, null);
                    }
                    else {
                        callback(null, result);
                    }
                });
            }
        });


    });
};

/**
 * Get all SSLQI from
 * @param loginOptions
 * @param callback
 */
exports.getAllSSLQI = function (loginOptions, callback) {
    console.log("Entering getAllSSLQI ...");
    let returnList = [];
    // Get from VistA
    getAllVistaSSLQI(loginOptions, function (vErr, vistaList) {
        // Get Mongo List
        if (vErr) {
            console.log('error');
            callback(mErr);
        }
        else {
            SSLQI.find({}, function (mErr, mongoList) {
                if (mErr) {
                    console.log('error');
                    callback(mErr);
                }
                else {
                    // Iterate through Mongo List and update according to VistA data
                    mergeSSLQI(vistaList, mongoList, function (err, result) {
                        if (err) {
                            console.log('error');
                            callback(err, null);
                        }
                        else {
                            callback(null, result);
                        }
                    });
                }
            });
        }
    });

};

/**
 * Get the specified SSLQI
 * @param loginOptions
 * @param id
 * @param callback
 */
exports.getById = function (loginOptions, id, callback) {

    SSLQI.findOne({_id: id}, function (err, sslqi) {
        if (!err) {
            callback(null, sslqi);
        }
        else {
            callback(err, null);
        }
    });
}

/**
 * Get the specified SSLQI
 * @param loginOptions
 * @param id
 * @param callback
 */
exports.getByVistaIdClassification = function (loginOptions, id, classification, callback) {

    SSLQI.findOne({vistaId: id, classification: classification}, function (err, sslqi) {
        if (!err) {
            callback(null, sslqi);
        }
        else {
            callback(err, null);
        }
    });
}

/**
 * Remove the specified SSLQI
 * @param loginOptions
 * @param id
 * @param callback
 */
exports.removeById = function (loginOptions, id, callback) {
    // TODO - Implement logic to remove from VistA
    SSLQI.remove({_id: id}, function (err, removed) {
        if (!err) {
            callback(null, removed);
        }
        else {
            callback(err, null);
        }
    });
}

/**
 * Remove the specified SSLQI
 * @param loginOptions
 * @param id
 * @param callback
 */
exports.removeByVistaIdClassifcation = function (loginOptions, id, classification, callback) {
    // TODO - Implement logic to remove from VistA
    SSLQI.remove({vistaId: id, classification: classification}, function (err, removed) {
        if (!err) {
            callback(null, removed);
        }
        else {
            callback(err, null);
        }
    });
}

/**
 * Create new SSLQI
 * @param data
 * @param callback
 */
function create(loginOptions, data, callback) {
    // console.log(data);
    let sslqi = new SSLQI(data);
    // TODO - implement logic to create in VistA

    // TODO - remove logic once able to write to VistA
    if (data === undefined){
        console.log('data undefined');
    }
    let maxId = data.vistaId || undefined;
    if (maxId === undefined) {
        // Get max vista id from mongo
        maxId = 0;
        console.log("trying to create id");
        // SSLQI.find({classification: data.classification}, null, {sort: {vistaId: 1}}, function (err, result) {
        getSSLQIForCriteria(loginOptions, {classification: data.classification}, function(err, result){
            //console.log("What are you: " + result);
            if (err || result === undefined || result === "") {
                maxId = 1;
            }
            else {
                if (result != undefined && result.length > 0) {
                    let i, x;
                    for (i = 0, x  = result.length; i < x; i++) {
                        console.log("Checking: " + result[i].vistaId);
                        maxId = (result[i].vistaId > maxId ? result[i].vistaId : maxId);
                    }
                    if (maxId !== undefined) {
                        maxId++;
                    }
                }
            }
            console.log("Max: " + maxId);
            sslqi.vistaId = maxId || 1;
            sslqi.save(function (err) {
                if (err) {
                    console.log(err);
                    callback(err, null);
                }
                else {
                    callback(null, sslqi);
                }
            });
        });
    }
    else {
        sslqi.save(function (err) {
            if (err) {
                console.log(err);
                callback(err, null);
            }
            else {
                callback(null, sslqi);
            }
        });
    }
}

/**
 * Import a list of SSLQI
 * @param data
 * @param callback
 */
function importSSLQI(loginOptions, data, index, importResult, callback) {
    // console.log(data);
    if (arguments.length === 3) {
        callback = index;
        index = 0;
        importResult = {};
        importResult.success = [];
        importResult.fail = [];
    }

    // Base case
    if (index === data.length) {
        callback(null, importResult);
    }
    else {
        if (Object.prototype.toString.call(data) == '[object Array]') {
            let temp;
            temp = data[index];

            create(loginOptions, data[index], function (err, result) {
                try {
                    if (err) {
                        console.log(err);
                        //callback(err, null);
                        temp["error"] = err.errmsg;
                        importResult["fail"].push(temp);
                    }
                    else {
                        console.log("Successfully imported: " + result);
                        importResult["success"].push(result);
                    }
                }
                catch (err) {
                    temp["error"] = err.errmsg;
                    importResult["fail"].push(temp);
                }
                finally {
                    importSSLQI(loginOptions, data, index + 1, importResult, callback);
                }
            });


        }
        else {
            console.log("Import data not an array: " + data);
            callback("Import data not an array", null);
        }
    }
}

/**
 * Edit existing SSLQI
 * @param data
 * @param callback
 */
exports.edit = function (loginOptions, data, classification, id, callback) {
    // TODO - Implement logic to update in VistA once RPC is available
    //console.log("Entering edit ...");
    if (data !== undefined && data !== null) {
        // console.log(data);
        SSLQI.findOne({vistaId: id, classification: classification}, function (err, existingSSLQI) {
            if (err) {
                callback(err, null);
            }
            else if (existingSSLQI === null || existingSSLQI === undefined) {
                console.log("SSLQI does not exist for vista id: " + data.vistaId + " - " + data.classification + ". Must be editing a VistA only SSLQI. Create new.");
                create(loginOptions, data, callback);
                //callback("SSLQI does not exist for vista id: " + data.vistaId + ".", null);
            }
            else {
                // Update
                for (var property in data) {
                    if (property !== "_id") {
                        existingSSLQI[property] = data[property];
                    }
                }
                // Check for properties to remove
                for (var property in existingSSLQI) {
                    if (property === "specialty" || property === "itemCategory"
                        || property === "itemType" || property === "itemSpecialtyType"
                        || property === "item" || property === "inventoryNumber"
                        || property === "classification" || property === "itemLocationFacility"
                        || property === "itemLocationRoom" || property === "itemStatus"
                        || property === "itemTypeQuantity" || property === "size"
                        || property === "manufacturer" || property === "vendor"
                        || property === "model" || property === "serialNumber"
                        || property === "mobilityIndicator" || property === "roomNumber"
                        || property === "reqRoomSize" || property === "shields"
                        || property === "environmentalInformation" || property === "size"
                        || property === "manufacturer" || property === "availability"
                        || property === "blockedTimes" || property === "attributeTags"
                        || property === "limitations" || property === "safetyMeasureThresholdMin"
                        || property === "safetyMeasureThresholdMax" || property === "comments"
                        || property === "poc") {
                        if (data[property] === undefined && existingSSLQI[property] !== undefined) {
                            // Remove property from existing SSLQI
                            existingSSLQI[property] = undefined;
                        }
                    }
                }
                existingSSLQI.save(function (err) {
                    if (err) {
                        console.log(err);
                        callback(err, null);
                    }
                    else {
                        console.log("SUCCESS");
                        callback(null, "SUCCESS");
                    }
                })
            }

        });
    }
    else {
        callback("No data provided.", null);
    }
}

/**
 * Edit existing SSLQI
 * @param data
 * @param callback
 */
exports.editById = function (loginOptions, data, id, callback) {
    // TODO - Implement logic to update in VistA once RPC is available
    //console.log("Entering edit ...");
    if (data !== undefined && data !== null) {
        console.log(data);
        SSLQI.findOne({_id: id}, function (err, existingSSLQI) {
            if (err) {
                callback(err, null);
            }
            else if (existingSSLQI === null || existingSSLQI === undefined) {
                console.log("SSLQI does not exist for id: " + id + ". Must be editing a VistA only SSLQI. Create new.");
                create(loginOptions, data, callback);
                //callback("SSLQI does not exist for vista id: " + data.vistaId + ".", null);
            }
            else {
                // Update
                for (var property in data) {
                    if (property !== "_id") {
                        existingSSLQI[property] = data[property];
                    }
                }
                // Check for properties to remove
                for (var property in existingSSLQI) {
                    if (property === "specialty" || property === "itemCategory"
                        || property === "itemType" || property === "itemSpecialtyType"
                        || property === "item" || property === "inventoryNumber"
                        || property === "classification" || property === "itemLocationFacility"
                        || property === "itemLocationRoom" || property === "itemStatus"
                        || property === "itemTypeQuantity" || property === "size"
                        || property === "manufacturer" || property === "vendor"
                        || property === "model" || property === "serialNumber"
                        || property === "mobilityIndicator" || property === "roomNumber"
                        || property === "reqRoomSize" || property === "shields"
                        || property === "environmentalInformation" || property === "size"
                        || property === "manufacturer" || property === "availability"
                        || property === "blockedTimes" || property === "attributeTags"
                        || property === "limitations" || property === "safetyMeasureThresholdMin"
                        || property === "safetyMeasureThresholdMax" || property === "comments"
                        || property === "poc") {
                        if (data[property] === undefined && existingSSLQI[property] !== undefined) {
                            // Remove property from existing SSLQI
                            existingSSLQI[property] = undefined;
                        }
                    }
                }
                existingSSLQI.save(function (err) {
                    if (err) {
                        console.log(err);
                        callback(err, null);
                    }
                    else {
                        console.log("SUCCESS");
                        callback(null, "SUCCESS");
                    }
                })
            }

        });
    }
    else {
        callback("No data provided.", null);
    }
}

/**
 * Retrieves all SSLQI from VistA
 * @param loginOptions
 * @param resultList
 * @param index
 * @param callback
 */
function getAllVistaSSLQI(loginOptions, resultList, index, callback) {
    let sslqi, temp, i;

    if (arguments.length === 3) {
        callback = index;
        index = 1;
    }
    else if (arguments.length === 2) {
        callback = resultList;
        resultList = [];
        index = 1;
    }

    if (index === 1) {
        // Special Equipment
        listService.getSpecialEquipment(loginOptions, function (seErr, seResult) {
            if (seErr) {
                console.log("Error when retrieving Pharmacy Items.");
                callback(seErr, null);
            }
            else {
                if (seResult != undefined && seResult.length > 0) {
                    for (i = 0; i < seResult.length; i++) {
                        temp = seResult[i];
                        sslqi = new SSLQI();
                        sslqi.vistaId = temp.id;
                        sslqi.item = temp.name;
                        sslqi.classification = SPECIAL_EQUIPMENT;
                        sslqi.itemStatus = (temp.inactive == "1" ? "Inactive" : "Active");
                        sslqi.specialty = temp.surgicalSpecialties;
                        resultList.push(sslqi);
                    }
                }
                getAllVistaSSLQI(loginOptions, resultList, index + 1, callback);
            }
        });
    }
    else if (index === 2) {
        // Planned Implant
        listService.getPlannedImplants(loginOptions, function (piErr, piResult) {
            if (piErr) {
                console.log("Error when retrieving Pharmacy Items.");
                callback(piErr, null);
            }
            else {
                if (piResult != undefined && piResult.length > 0) {
                    for (i = 0; i < piResult.length; i++) {
                        temp = piResult[i];
                        sslqi = new SSLQI();
                        sslqi.vistaId = temp.id;
                        sslqi.item = temp.name;
                        sslqi.classification = PLANNED_IMPLANT;
                        sslqi.itemStatus = (temp.inactive == "1" ? "Inactive" : "Active");
                        sslqi.specialty = temp.surgicalSpecialties;
                        sslqi.size = temp.number;
                        sslqi.model = temp.model;
                        sslqi.vendor = temp.vendor;
                        resultList.push(sslqi);
                    }
                }
                getAllVistaSSLQI(loginOptions, resultList, index + 1, callback);
            }
        });
    }
    else if (index === 3) {
        // Pharmacy Items
        listService.getPharmacyItems(loginOptions, function (pItemsErr, pItemsResult) {
            if (pItemsErr) {
                console.log("Error when retrieving Pharmacy Items.");
                callback(pItemsErr, null);
            }
            else {
                if (pItemsResult != undefined && pItemsResult.length > 0) {
                    for (i = 0; i < pItemsResult.length; i++) {
                        temp = pItemsResult[i];
                        sslqi = new SSLQI();
                        sslqi.vistaId = temp.id;
                        sslqi.item = temp.drugName;
                        sslqi.classification = PHARMACY_ITEMS;
                        sslqi.itemStatus = (temp.inactive == "1" ? "Inactive" : "Active");
                        sslqi.comments = temp.drugComments;
                        sslqi.specialty = temp.surgicalSpecialties;
                        sslqi.itemUsage = temp.dose;
                        resultList.push(sslqi);
                    }
                }
                getAllVistaSSLQI(loginOptions, resultList, index + 1, callback);
            }
        });
    }
    else if (index === 4) {
        // Special Instruments
        listService.getSpecialInstruments(loginOptions, function (siErr, siResult) {
            if (siErr) {
                console.log("Error when retrieving Pharmacy Items.");
                callback(siErr, null);
            }
            else {
                if (siResult != undefined && siResult.length > 0) {
                    for (i = 0; i < siResult.length; i++) {
                        temp = siResult[i];
                        sslqi = new SSLQI();
                        sslqi.vistaId = temp.id;
                        sslqi.item = temp.name;
                        sslqi.classification = SPECIAL_INSTRUMENTS;
                        sslqi.itemStatus = (temp.inactive == "1" ? "Inactive" : "Active");
                        sslqi.specialty = temp.surgicalSpecialties;
                        sslqi.size = temp.number;
                        resultList.push(sslqi);
                    }
                }

                getAllVistaSSLQI(loginOptions, resultList, index + 1, callback);
            }
        });
    }
    else if (index === 5) {
        // Special Supplies
        listService.getSpecialSupplies(loginOptions, function (ssErr, ssResult) {
            if (ssErr) {
                console.log("Error when retrieving Special Supplies.");
                callback(ssErr, null);
            }
            else {
                if (ssResult != undefined && ssResult.length > 0) {
                    for (i = 0; i < ssResult.length; i++) {
                        temp = ssResult[i];
                        sslqi = new SSLQI();
                        sslqi.vistaId = temp.id;
                        sslqi.item = temp.name;
                        sslqi.classification = SPECIAL_SUPPLIES;
                        sslqi.itemStatus = (temp.inactive == "1" ? "Inactive" : "Active");
                        sslqi.specialty = temp.surgicalSpecialties;
                        sslqi.size = temp.number;
                        sslqi.model = temp.model;
                        sslqi.vendor = temp.vendor;
                        resultList.push(sslqi);
                    }
                }
                getAllVistaSSLQI(loginOptions, resultList, index + 1, callback);
            }
        });
    }
    else {
        callback(null, resultList);
    }
}

/**
 * Merges a list of SSLQI objects
 * @param vistaObjects
 * @param mongoObjects
 * @param callback
 */
function mergeSSLQI(vistaObjects, mongoObjects, callback) {
    // Set mongo objects
    let returnList = [];
    mongoObjects = mongoObjects || [];
    let i, j;
    if (vistaObjects === undefined || vistaObjects === null || vistaObjects.length === 0) {
        callback(null, mongoObjects);
    }
    else if (mongoObjects === undefined || mongoObjects === null || mongoObjects.length === 0) {
            callback(null, vistaObjects);
    }
    else {
        let addVistaObject = true;
        returnList = mongoObjects;
        for (i = 0; i < vistaObjects.length; i++) {
            addVistaObject = true;
            for (j = 0; j < mongoObjects.length; j++) {
                if (vistaObjects[i].vistaId === mongoObjects[j].vistaId && vistaObjects[i].classification === mongoObjects[j].classification) {
                    addVistaObject = false;
                    updateSSLQI(vistaObjects[i], mongoObjects[j], function (err, result) {
                        if (err) {
                            console.log("Error when updating SSLQI: " + err);
                            callback(err, null);
                        }
                        else {
                            returnList[j] = result;
                        }
                    });
                }
            }
            if (addVistaObject) {
                returnList.push(vistaObjects[i]);
            }
        }
    callback(null, returnList);
    }

}

/**
 * Combines tha attributes of a mongo SSLQI object with a vista SSLQI object
 * @param vistaObject
 * @param mongoObject
 * @param callback
 */
function updateSSLQI(vistaObject, mongoObject, callback) {
    if (vistaObject === undefined || vistaObject === null) {
        callback(null, mongoObject);
    }
    else if (mongoObject === undefined || mongoObject === null) {
        callback(null, vistaObject);
    }
    else {
        // Iterate through vistaObject properties and update mongo object
        for (var property in vistaObject) {
            if (property === "specialty") {
                mongoObject.specialty = _.union(vistaObject.specialty, mongoObject.specialty);
            }
            else if (property === "poc" || property === "itemCategory"
                || property === "itemType" || property === "itemSpecialtyType"
                || property === "item" || property === "inventoryNumber"
                || property === "classification" || property === "itemLocationFacility"
                || property === "itemLocationRoom" || property === "itemStatus"
                || property === "itemTypeQuantity" || property === "size"
                || property === "manufacturer" || property === "vendor"
                || property === "model" || property === "serialNumber"
                || property === "mobilityIndicator" || property === "roomNumber"
                || property === "reqRoomSize" || property === "shields"
                || property === "environmentalInformation" || property === "size"
                || property === "manufacturer" || property === "availability"
                || property === "blockedTimes" || property === "attributeTags"
                || property === "limitations" || property === "safetyMeasureThresholdMin"
                || property === "safetyMeasureThresholdMax" || property === "comments") {

                if ((vistaObject[property] !== undefined && vistaObject[property] !== "")
                    && (mongoObject[property] === undefined || mongoObject[property] === "")) {
                    // Update mongo object
                    mongoObject[property] = vistaObject[property];
                }
            }
        }
        callback(null, mongoObject);
    }
}

function comparePropertiesForSearch(caseParam, queryParam){

    let caseParamType = Object.prototype.toString.call(caseParam), queryParamType = Object.prototype.toString.call(queryParam);

    if ((caseParam === undefined && queryParam === undefined) || queryParam === undefined || (queryParamType == "[object Array]" && queryParam.length === 0)) {
        console.log("first if statment -> true");
        return true;
    }
    else if (caseParamType === queryParamType){
        if (caseParam == queryParam){
            return true;
        }
        else if (caseParamType == "[object Array]") {
            let result = false;
            for (let i = 0, x = queryParam.length; i < x; i++){
                result = false;
                for(let j = 0, y = caseParam.length; j < y; j++){
                    if (queryParam[i] == caseParam[j]){
                        result = true;
                        break;
                    }
                }

                if (result === false){
                    return false;
                }
            }
            return result;
        }
    }
    else {
        return caseParam == queryParam;
    }
}
// Functions
exports.create = create;
exports.importSSLQI = importSSLQI;
exports.getSSLQIForCriteria = getSSLQIForCriteria;

// Constants
const SPECIAL_EQUIPMENT = 'Equipment';
const PLANNED_IMPLANT = 'Implant';
const PHARMACY_ITEMS = 'Pharmacy';
const SPECIAL_INSTRUMENTS = 'Instrument';
const SPECIAL_SUPPLIES = 'Supplies';