'use strict';
const mongoose = require('mongoose');
const SpecialtyRoomConfig = mongoose.model('SpecialtyRoomTypeMapping');


/**
 * Get default room based on criteria
 * @param loginOptions
 * @param criteria [Room ID, specialty, orNonOr]
 * @param callback
 */
exports.getRoomForCriteria = function (loginOptions, criteria, callback) {
    console.log("Entering getRoomForCriteria ...");
    let defaultRoom = criteria.defaultRoom || undefined;
    let specialty = criteria.specialty || undefined;
    let orNor = criteria.orNonOr || undefined;
    let query = {};

    // Build query
    if (defaultRoom !== undefined) {
        query["defaultRoom"] = defaultRoom;
    }
    if (specialty !== undefined) {
        query["specialty"] = specialty;
    }
    if (orNor !== undefined) {
        query["orNonOr"] = orNor;
    }
    // Execute query
    SpecialtyRoomConfig.find(query, function (err, data) {
        if (!err) {
            callback(data);
        } else {
            console.log('error');
            callback(err);
        }
    });
};

/**
 * Get all default rooms from
 * @param loginOptions
 * @param callback
 */
exports.getAllConfigs = function (loginOptions, callback) {
    console.log("Entering getAllConfigs ...");

    // Execute query
    SpecialtyRoomConfig.find({}, function (err, data) {
        if (!err) {
            callback(data);
        } else {
            console.log('error');
            callback(err);
        }
    });
};

/**
 * Get the specified room type mapping
 * @param loginOptions
 * @param id
 * @param callback
 */
exports.getRoomTypeConfig = function (loginOptions, id, callback) {
    SpecialtyRoomConfig.findOne({specialty: id}, function (err, result) {
        if (!err) {
            callback(null, result);
        }
        else {
            callback(err, null);
        }
    });
}

/**
 * Remove the specified room type mapping
 * @param loginOptions
 * @param id
 * @param callback
 */
exports.removeRoomTypeConfig = function (loginOptions, id, callback) {
    SpecialtyRoomConfig.remove({specialty: id}, function (err, removed) {
        if (!err) {
            callback(null, removed);
        }
        else {
            callback(err, null);
        }
    });
}

/**
 * Create new room type configuration
 * @param data
 * @param callback
 */
exports.create = function(data, callback){
    console.log(data);
    const newDefault = new SpecialtyRoomConfig(data);
    newDefault.save(function(err){
        if(err) {
            console.log(err);
            callback(err, null);
        }
        else {
            callback(null, newDefault);
        }
    });
}

/**
 * Edit existing room type mapping
 * @param data
 * @param callback
 */
exports.edit = function(data, id, callback) {
    // TODO Implement audit for changes
    //console.log("Entering edit ...");
    if (data !== undefined && data !== null) {
        SpecialtyRoomConfig.findOne({specialty: id}, function (err, existingConfig) {
            if (err) {
                callback(err, null);
            }
            else if (existingConfig === null || existingConfig === undefined) {
                console.log(existingConfig);
                callback("Specialty room type configuration does not exist for specialty id: " + data.specialty + ".", null);
            }
            else {
                // Update role
                for (var property in data) {
                    if (property !== "_id") {
                        // TODO Implement audit for changes
                        existingConfig[property] = data[property];
                    }
                }
                // Check for properties to remove
                for (var property in existingConfig) {
                    if (property === "defaultRoom" || property === "orNonOr") {
                        if (data[property] === undefined && existingConfig[property] !== undefined) {
                            // Remove property from existing config
                            existingConfig[property] = undefined;
                        }
                    }
                }
                existingConfig.save(function (err) {
                    if (err) {
                        console.log(err);
                        callback(err, null);
                    }
                    else {
                        console.log("SUCCESS");
                        callback(null, "SUCCESS");
                    }
                })
            }

        });
    }
    else {
        callback("No data provided.", null);
    }
}