/**
 * Site Service
 * @author atignola
 */
// required imports
const mongoose = require('mongoose');
// note the import of the mongoose model
const Site = mongoose.model('Site');


/**
 * Create new site
 * @param site_data
 * @param callback
  */
exports.create = function(site_data, callback){
	const config = new Site(site_data);
	// save function, will create a new record in the card collection in mongo
	config.save(function(err){
		if(err) {console.log(err); callback( err);}
		callback(config); 
	});
}

/**
 * Get the list of facilities for login page
 * @param callback
 */
exports.getFacilitiesList = function(callback){
	//console.log("Site.findAll");
	Site.find({}, 'stationID facilityName', {sort: {facilityName: 1}}, function(err, docs){
		if(!err){
			callback(docs);
		} else {
			callback(err);
		}
	});
}

/**
Function find all sites
 @param callback
*/
exports.findAll = function(callback){
	//console.log("Site.findAll");
	Site.find({}, null, {sort: {facilityName: 1}}, function(err, docs){
		if(!err){
			callback(docs);
		} else {
			callback(err);
		}
	});
}

/**
Find site by stationID
 @param stationID
 @param callback
*/
exports.find = function(stationID, callback){
	Site.findOne({stationID:stationID},function(err, docs){
		//console.log("Site.find");
		if(!err){
			callback(docs);
		} else {
			callback(err);
		}
	});
}

/**
 Get the IP adcress of the site specified by stationID
 @param stationID
 @param callback
 */
exports.getConnectionInfo = function(stationID, callback){
	Site.findOne({stationID:stationID}, 'ipAddress port', function(err, docs){
		//console.log("Site.find");
		if(!err){
			callback(docs);
		} else {
			callback(err);
		}
	});
}
/**
 Delete site by stationID
 @param stationID
 @param callback
 */
exports.remove = function(stationID, callback){
	Site.remove({stationID:stationID},function(err, removed){
		//console.log(removed);
		if(!err){callback (removed);}
		else {console.log(err);}
	});
}