
const mongoose = require('mongoose');
const SetField = mongoose.model('SetField');



/**
 Function Find by Title
 */
exports.findByTitle = function(title, callback){
    // empty find {} will return all
    //Site.find({}, 'stationID facilityName', {sort: {facilityName: 1}}, function(err, docs){
    SetField.find({title:title}, 'code value', {sort: {value: 1}},function(err, docs){
        if(!err){
            callback(docs);
        } else {
            callback(err);
        }
    });
}


exports.CASE_SCHEDULE_TYPE = "caseScheduleType";
exports.PRE_OP_INFECTION = "preOpInfection";
exports.ANESTHESIA_TECHNIQUE = "anesthesiaTechnique";
exports.ADMISSION_STATUS = "admissionStatus";
exports.INTRAOPERATIVE_XRAYS = "intraoperativeXrays";
exports.BLOOD_TYPE_X_MATCH = "bloodTypeXmatch";
exports.CANCEL_TIME_FRAME = "cancelTimeframe";
exports.BLOOD_PRODUCT_INFO = "bloodProductInfo";
exports.PROCEDURE_LATERALITY = "procedureLaterality";
exports.CASE_TYPE = "case_type";
exports.CASE_STATUS = "case_status";
exports.SSLQI_CLASSIFICATION = "sslqi_classification";

// OP/PRE-OP SET FIELDS
exports.PACKING = "packing";
exports.PATIENT_EDU_ASSESSMENT= "patient_edu_assessment";
exports.WOUND_CLASSIFICATION = "wound_classification";
exports.HAIR_REMOVAL_METHOD = "hair_removal_method";
// RISK ASSESSMENT SET FIELDS
exports.GENERAL = "general"
exports.DIABETES_MELITUS = "diabetes_mellitus";
exports.TOBACCO_USE = "tobacco_use";
exports.TOBACCO_TIMEFRAME= "tobacco_timeframe";
exports.TWO_DRINKS_PER_DAY = "two_drinks_day"
exports.POSITIVE_DR_SCRN = "positive_drug_screening";
exports.DYSPNEA = "dyspnea";
exports.PREOP_SLEEP_APNEA = "preop_sleep_apnea";
exports.DNR_STATUS = "dnr_status"
exports.FUNCTIONAL_HEALTH_STATUS = "functional_health_status";
exports.RESIDENCE = "residence";
exports.AMBULATION_DEVICE= "ambulation_device";
exports.HOMELESS = "homeless";
exports.PULMONARY = "pulmonary"
exports.VENTILATOR_DEPENDENT = "ventilator_dependent"
exports.COPD_HISTORY = "copd_history"
exports.CURRENT_PNEUMONIA = "current_pneumonia"
exports.HEPATOBILIARY = "hepatobiliary"
exports.ASCITES = "ascites"
exports.GASTROINTESTINAL = "gastrointestinal"
exports.ESOPHAGEAL_VARICES = "esophageal_varices"
exports.CONGESTIVE_HEART_FAILURE_PREOP = "congestive_heart_failure_preop";
exports.CARDIAC = "cardiac"
exports.PRIOR_MI = "prior_mi";
exports.PCI = "pci";
exports.ANGINA_TIMEFRAME = "angina_timeframe";
exports.ANGINA_SEVERITY = "angina_severity";
exports.HYPERTENSION = "hypertension"
exports.PRIOR_SURG_SAME_OP_FIELD = "prior_surg_same_op_field";
exports.HX_RAD_RX_PLANNED_SURG_FIELD = "hx_rad_rx_planned_surg_field"
exports.DONOR_SEROLOGY = "donor_serology";
exports.VASCULAR = "vascular"
exports.PERIPHERAL_ARTERIAL_DISEASE= "peripheral_arterial_disease";
exports.REST_PAIN_GAINGRENE = "rest_pain_gaingrene"
exports.RENAL = "renal"
exports.RENAL_FAILURE = "renal_failure"
exports.ON_DIALYSIS = "on_dialysis"
exports.CENTRAL_NERV_SYS_ILLNESS = "central_nerv_sys_illness"
exports.IMPAIRED_SENSORIUM = "impaired_sensorium"
exports.COMA = "coma"
exports.HEMIPLEGIA_HEMIPARESES = "hemiplegia_hemiparesis"
exports.HISTORY_OF_CVD = "history_of_cvd";
exports.CNS_TUMOR = "tumor_involving_cns"
exports.IMPAIRED_COGNITIVE_FUNCTION = "impaired_cognitive_function";
exports.NUTRITIONAL_IMMUNE_OTHER = "nutritional_immune_other"
exports.DISSEMINATED_CANCER = "disseminated_cancer"
exports.OPEN_WOUND = "open_wound"
exports.CHRONIC_STEROID_USE = "chronic_steroid_use"
exports.TEN_PERC_WEIGHT_LOSS = "ten_perc_weight_loss"
exports.BLEEDING_DISORDERS = "bleeding_disorders"
exports.MED_BLEEDING_RISK = "medication_bleeding_risk";
exports.TRANSFUSION_GT_FOUR_RBCS = "transfusion_gt_four_rbcs"
exports.MAILG_CHEMO = "malig_chemo";
exports.RADIO_THERAPY_LAST_NINETY = "radio_therapy_last_ninety";
exports.PREOP_SEPSIS = "preop_sepsis";
exports.PREGNANCY = "pregnancy";
exports.ASSESSMENT_TYPE = "assessment_type";

/*
exports.YES_NO = "yes_no";
exports.YES_NO_NO_STUDY = "yes_no_ns";
exports.YES_NO_NOT_APPLICABLE = "yes_no_na";
*/