/**
 * Site Service
 * @author atignola
 */
// required imports
const mongoose = require('mongoose');
// note the import of the mongoose model
const Provider = mongoose.model('Provider');

/**
* Work time by provider
*/
exports.getProviderWorkTime = function(provider_ien, callback){
	Provider.findOne({'ien': provider_ien}, function(err, provider){
		if(err) {console.log(err); callback( err);}
		callback(err, provider); 
	});
}

/**
* update provider work time
*/
exports.updateProviderWorkTime = function(data, callback){
	let query = {'ien': data.ien};
	Provider.findOneAndUpdate(query, data, {upsert: true}, function(err){
		if(err) {
			console.log("Error in provider save", err);
			callback({err: err});
		}else{
			callback({success: true});
		}
	});
}