/**
 * Site Service
 * @author atignola
 */
// required imports
const mongoose = require('mongoose');
// note the import of the mongoose model
const Notification = mongoose.model('Notification');

/**
* Get all notifications by user ien
*/
exports.getNotifications = function(user_ien, callback){
	Notification.find({'user_ien': user_ien}, function(err, notifications){
		if(err) {console.log(err); callback( err);}
		callback(err, notifications); 
	});
}

/**
* add notification
*/
exports.addNotification = function(notification_data, callback){
	let notification = new Notification(notification_data);

	let cb_func = function(err){
		if(err) {
			console.log("Error in notification save", err);
			callback({err: err}, {success: false});
		}else{
			callback({success: true});
		}
	};

	if("_id" in notification){
		Notification.findOneAndUpdate({"_id": notification._id}, notification, cb_func);
	}else{
		notification.save(cb_func);	
	}
	
}




/**
* delete notification
**/
exports.deleteNotification = function(notification_id, callback){
	Notification.remove({"_id": notification_id}, function(err){
		if(err){
			callback({err: err, success: false});
		}else{
			callback({success: true})
		}
	})
}