'use strict';
const mongoose = require('mongoose');
const NameDescription = mongoose.model('NameDescription');


/**
 * Creates a new NameDescription object with data
 * @param data
 * @param callback
 */
function createNameDescription(data, callback){
    let nameDescription = new NameDescription(data);
    nameDescription.save(function (err) {
        if (err){
            callback(err, null);
        }
        else{
            callback(null, nameDescription);
        }
    })
}

/**
 * Retrieves NameDescription object by ID
 */
exports.getNameDescriptionByIdCategory = function(id, category, callback){
    NameDescription.findOne({_id: id, category:category}, 'name description', callback);
}

/**
 * Retrieves all NameDescription objects
 */
exports.getNameDescriptionByCategory = function(category, callback){
    NameDescription.find({category:category}, 'name description', callback);
}

/**
 * Edits an existing NameDescription object defined by id
 * @param id
 * @param data
 * @param callback
 */
exports.editNameDescription = function(id, category, data, callback){
    let name = data["name"] || undefined,
        description = data["description"] || undefined;

    NameDescription.findOne({_id: id, category:category}, function(err, existingNameDescription){

        if (err){
            console.log(err);
            callback(err, null);
        }
        else if (existingNameDescription === null || existingNameDescription === undefined){
            createNameDescription(data, callback);
        }
        else {
            if (name !== undefined){
                existingNameDescription.name = name;
            }
            if (description !== undefined){
                existingNameDescription.description = description;
            }

            existingNameDescription.save(function (error, updatedDoc) {
                if (error) {
                    console.log(error);
                    callback(error, null);
                }
                else {
                    callback(null, updatedDoc);
                }
            });
        }
    });
}

/**
 * Delete an existing NameDescription object defined by id
 * @param id
 * @param data
 * @param callback
 */
exports.removeNameDescription = function(id, category, callback){
    NameDescription.findOne({_id: id, category: category}, function(err){
        if (err){
            callback(err, null);
        }
        else {
            NameDescription.remove({_id: id}, (callback));
        }
    });
}

// Exports
exports.createNameDescription = createNameDescription;

const PROCEDURE_CATEGORY_CATEGORY = "procedureCategory";

exports.PROCEDURE_CATEGORY_CATEGORY = PROCEDURE_CATEGORY_CATEGORY;