'use strict';
const mongoose = require('mongoose');
const ExtendedCase = mongoose.model('ExtendedCase');

/**
 * Creates a new extendedCase object with data
 * @param data
 * @param callback
 */
 function createExtendedCase(data, callback){
    let extendedCase = new ExtendedCase(data);
    extendedCase.save(function (err) {
        if (err){
            callback(err, null);
        }
        else{
            callback(null, extendedCase);
        }
    })
}

/**
 * Retrieves extendedCase object by VistA ID
 */
exports.findById = function(vistaId, callback){
    ExtendedCase.findOne({vistaId: vistaId}, callback);
}

/**
 * Retrieves all extendedCase objects
 */
exports.getAllExtendedCases = function(callback){
    ExtendedCase.find({}, callback);
}

/**
 * Edits an existing extendedCase object defined by VistaID
 * @param vistaId
 * @param data
 * @param callback
 */
exports.editExtendedCase = function(vistaId, data, callback){
    let estimatedOverTime = data.estimatedOverTime || undefined,
        affectedCases = data.affectedCases || undefined;
    ExtendedCase.findOne({vistaId: vistaId + ""}, function(err, existingExtendedCase){

        if (err){
            callback(err, null);
        }
        else if (existingExtendedCase === null || existingExtendedCase === undefined){
            createExtendedCase(data, callback);
        }
        else {
            if (estimatedOverTime !== undefined) {
                existingExtendedCase.estimatedOverTime = estimatedOverTime;
            }
            if (affectedCases !== undefined) {
                existingExtendedCase.affectedCases = affectedCases;
            }
            existingExtendedCase.save(function (error, updatedDoc) {
                if (error) {
                    callback(error, null);
                }
                else {
                    callback(null, updatedDoc);
                }
            });
        }
    });
}

/**
 * Delets an existing extendedCase object defined by VistaID
 * @param vistaId
 * @param data
 * @param callback
 */
exports.removeExtendedCase = function(vistaId, data, callback){
    ExtendedCase.findOne({vistaId: vistaId}, function(err){
        if (err){
            callback(err, null);
        }
        else {
            ExtendedCase.remove({vistaId: vistaId}, (callback));
        }
    });
}

// Exports
exports.createExtendedCase = createExtendedCase;