
const mongoose = require('mongoose');
const Audit = mongoose.model('Audit');


/**
 * Create a new audit entry
 * @param id
 * @param data
 * @param endpoint
 * @param username
 * @param callback
 */
exports.createNewEntry = function(id, data, endpoint, username, auditType, dataType, callback){
    const audit = new Audit();

    // Handle method call with no dataType specified
    if (arguments.length === 6 && id !== undefined && id  !== null) {
    	callback = dataType;
        if (isNaN(id)){dataType = this.MDB_DT;}
		else {dataType = this.VISTA_DT};
	}

	// Populate model data
	audit.dateTime = new Date();
	audit.transactionType = auditType;
	audit.content = data;
	audit.username = username;
	audit.endpoint = endpoint;

	// Set the appropriate ID
	if (id !== undefined && id  !== null){
		if ((dataType !== undefined && dataType === this.MDB_DT))
		{
			audit.mongoId = id;
		}
		else if ((dataType !== undefined && dataType === this.VISTA_DT))
		{
			audit.vistaId = id;
		}
	}
	// Save
    audit.save(function(err){
        if(err) {console.log(err); callback(err, null);}
        callback(null, audit);
    });
}

/**
Function Find all
*/
exports.findAll = function(callback){
	// empty find {} will return all
	Audit.find({}, function(err, docs){
		if(!err){
			callback(docs);
		} else {
			callback(err);
		}
	});
}


exports.VISTA_DT = "VISTA";
exports.MDB_DT = "MONGO";
exports.UNKNOWN_DT = "UNKNOWN";
exports.CREATE = "CREATE";
exports.UPDATE = "UPDATE";
exports.DELETE = "DELETE";