'use strict';
const vistaconfig = require("../../lib/rpcvista/vistaconfig");
const vista = require("../../lib/rpcvista/vista_surgery_services");
const site = require("./cnf/site");
const errorHandler = require("../common/errorHandler");

/**
* Verify that access code and verify code are valid
**/
exports.verify = function(loginOptions, callback){
  this.buildConfiguration(loginOptions, function(result){
    vista.authenticate(vistaconfig.logger, result, callback);
  });
}

exports.retrieveKeys = function(loginOptions, ien, callback){
  this.buildConfiguration(loginOptions, function(configuration){
    vista.callRpc(
        vistaconfig.logger,
        configuration,
        'SR GET USRKEYS',
        ien,
        function(error, result){
          if (error){
            callback(errorHandler.serverIssue(error), null);
          }
          else if (result === undefined || result instanceof Error) {
            callback(errorHandler.serverIssue(result), null);
          } else {
            console.log('roles');
            console.log(result);
            callback(null, result);
          }
        }
    )

  });
}

exports.userInfo = function(loginOptions, callback){
  this.buildConfiguration(loginOptions, function(configuration){
    vista.callRpc(
        vistaconfig.logger,
        configuration,
        'ORWU USERINFO',
        function(error, result){
          if (result === undefined || result instanceof Error) {
            callback(result, null);
          } else {
            console.log('userInfo', result);

            /*
            This is the return of this USER INFO call

            DUZ^NAME^USRCLS^CANSIGN^ISPROVIDER^ORDERROLE
            ^NOORDER^DTIME^COUNTDOWN^ENABLEVERIFY^NOTIFYAPPS
            ^MSGHANG^DOMAIN^SERVICE^AUTOSAVE^INITTAB^LASTTAB
            ^WEBACCESS^ALLOWHOLD^ISRPL^RPLLIST^CORTABS^RPTTAB
            ^STANUM^GECSTATUS^PRODACCT
            */

            let key_array = ["duz","name","usrcls","cansign","isprovider","orderrole",
            "noorder","dtime","countdown","enableverify","notifyapps",
            "msghang","domain","service","autosave","inittab","lasttab",
            "webaccess","allowhold","isrpl","rpllist","cortabs","rpttab",
            "stanum","gecstatus","prodacct"];
            let result_array = result.split("^");

            let data = {};

            for(var i = 0; i < result_array.length; i++){
              data[key_array[i]] = result_array[i];
            }

            callback(error, data);
          }
        }
    )

  });
}

exports.buildConfiguration = function(loginOptions, callback) {
  site.getConnectionInfo(loginOptions[vistaconfig.STATION_CONFIG_KEY], function(result){
    let configuration = vistaconfig.configuration;

    // TODO - update this logic
    configuration[vistaconfig.ACCESS_CONFIG_KEY] = loginOptions[vistaconfig.ACCESS_CONFIG_KEY] || loginOptions[vistaconfig.T_ACCESS_CONFIG_KEY];
    configuration[vistaconfig.VERIFY_CONFIG_KEY] = loginOptions[vistaconfig.VERIFY_CONFIG_KEY] || loginOptions[vistaconfig.T_VERIFY_CONFIG_KEY];

      if (result != undefined && result.ipAddress != undefined && result.port != undefined) {
        configuration[vistaconfig.HOST_CONFIG_KEY] = result.ipAddress;
        configuration[vistaconfig.PORT_CONFIG_KEY] = result.port;
      }
    callback(configuration);
  });
}