'use strict';
require('dotenv').config();
const express = require('express'),
    roomRouter = express.Router();

const roomService = require("../../services/rpc/room");
const caseService = require("../../services/rpc/case");


roomRouter.route("/all")
    .get(function(req, res){
        roomService.getRooms(req.decoded, function(error, result){
            if(error){
                res.status(error.statusCode || 500).json(error);
            }else{
                res.json(result);
            }
        });
    });

roomRouter.route("/openhours/:roomien")
    .get(function(req, res){
        roomService.getRoomHours(req.decoded, req.params.roomien, function(error, result){
            if(error){
                res.status(error.statusCode || 500).json(error);
            }else{
                res.json(result);
            }
        });
    });


roomRouter.route("/or/case/:id")
    .get(function(req, res){
        roomService.getRoomDetailsByCaseId(req.decoded, req.params.id, function(error, result){
            if(error){
                console.log(error);
                res.status(error.statusCode || 500).json(error);
            }
            else{
                res.json(result);
            }
        });
    });


roomRouter.route("/or/:id")
    .get(function(req, res){
        roomService.getRoomDetailsById(req.decoded, req.params.id, function(error, result){
            if(error){
                console.log(error);
                res.status(error.statusCode || 500).json(error);
            }
            else{
                res.json(result);
            }
        });
    });

/**
* get the events for a room by date
**/
roomRouter.route("/or/events/:room_id/:date")
    .get(function(req, res){

        roomService.getEventsForRoomByDay(
            req.decoded, 
            req.params.room_id, 
            new Date(req.params.date), 
            function(error, result){
                if(error){
                    console.log(error);
                    res.status(error.statusCode || 500).json(error);
                }
                else{
                    console.log("Result in events: "+result);
                    res.json(result);
                }
        });
    });

module.exports = roomRouter;