'use strict';
require('dotenv').config();
const express = require('express'),
    placeholderRouter = express.Router();
const caseService = require("../../services/rpc/case");
const util = require("../utils");


/************************
 *   Placeholder Routes  *
 ************************/
placeholderRouter.route("/")
    .post(function(req, res){
        caseService.createPlaceholderCase(req.decoded, req.body, function(err, result){
            if(err){ res.json(err);}
            else{res.json(result);}
        });
    });

/**
 * Updates an existing placeholder case with new data
 */
placeholderRouter.route("/")
    .put(function(req, res){
        caseService.editExistingORCase(req.decoded, req.body, function(err, result){
            if(err){ res.json(err);}
            else{res.json(result);}
        });
    });

placeholderRouter.route("/")
    .get(function(req, res){
        caseService.searchCases(req.decoded,{"caseType": "PLACEHOLDER"}, function(err, result){
            if(err){ res.json(err);}
            else{res.json(result);}
        });
    });

placeholderRouter.route("/:startdate/:enddate")
    .get(function(req, res){
        var start = new Date(req.params.startdate);
        var end = new Date(req.params.enddate);

        // Modify date to reflect correct date passed
        start.setDate(start.getDate() + 1);
        end.setDate(end.getDate() + 1);

        caseService.searchCases(req.decoded, {"caseType": "OR", "dateRange":{"start":start, "end":end}}, function(err, result){
            if(err){ res.json(err);}
            else{res.json(result);}
        });
    });

placeholderRouter.route("/date/:year/:month")
    .get(function(req, res){
        util.lastDayOfMonth(req.params.month, req.params.year, function(endDay){
            caseService.searchCases(req.decoded, {"caseType": "OR", "dateRange": {"start":new Date(req.params.year, req.params.month - 1, 1), "end":new Date(req.params.year, req.params.month - 1, endDay)}}, function(err, result){
                if(err){ res.json(err);}
                else{res.json(result);}
            });
        });
    });

placeholderRouter.route("/date/:year/:month/:day")
    .get(function(req, res){
        let day = parseInt(req.params.day, 10);
        caseService.searchCases(req.decoded, {"caseType": "OR", "dateRange": {"start":new Date(req.params.year, req.params.month - 1, day), "end":new Date(req.params.year, req.params.month - 1, day + 1 )}}, function(err, result){
            if(err){res.json(err);}
            else{res.json(result);}
        });
    });

placeholderRouter.route("/export/")
    .get(function(req, res){
        caseService.searchCases(req.decoded,{"caseType": "PLACEHOLDER"}, function(err, result){
            if(err){ res.json(err);}
            else{res.json(result);}
        });
    });

placeholderRouter.route("/export/:startdate/:enddate")
    .get(function(req, res){
        var start = new Date(req.params.startdate);
        var end = new Date(req.params.enddate);

        // Modify date to reflect correct date passed
        start.setDate(start.getDate() + 1);
        end.setDate(end.getDate() + 1);

        caseService.searchCases(req.decoded, {"caseType": "OR", "dateRange":{"start":start, "end":end}}, function(err, result){
            if(err){ res.json(err);}
            else{res.json(result);}
        });
    });

placeholderRouter.route("/export/date/:year/:month")
    .get(function(req, res){
        util.lastDayOfMonth(req.params.month, req.params.year, function(endDay){
            caseService.searchCases(req.decoded, {"caseType": "OR", "dateRange": {"start":new Date(req.params.year, req.params.month - 1, 1), "end":new Date(req.params.year, req.params.month - 1, endDay)}}, function(err, result){
                if(err){ res.json(err);}
                else{res.json(result);}
            });
        });
    });

placeholderRouter.route("/export/date/:year/:month/:day")
    .get(function(req, res){
        let day = parseInt(req.params.day, 10);
        caseService.searchCases(req.decoded, {"caseType": "OR", "dateRange": {"start":new Date(req.params.year, req.params.month - 1, day), "end":new Date(req.params.year, req.params.month - 1, day + 1 )}}, function(err, result){
            if(err){res.json(err);}
            else{res.json(result);}
        });
    });

placeholderRouter.route("/import")
    .post(function(req, res){
        caseService.importCases(req.decoded, req.body, function(err, result){
            if(err){ res.json(err);}
            else{res.json(result);}
        });
    });


module.exports = placeholderRouter;