'use strict';
require('dotenv').config();
let express = require('express'),
	patientRouter = express.Router();

const patientService = require("../../services/rpc/patient");
const caseService = require("../../services/rpc/case");

/*********************
 *   Patient Routes  *
 *********************/

patientRouter.route("/all")
	.get(function(req, res){
		patientService.getAllPatientData(req.decoded, function(err, result){
			if(err) {res.status(err.statusCode || 500).json(err);}
			else {res.json(result);}
		});
	});

/**
GET patient by SSN
**/
patientRouter.route("/ssn/:ssn")
	.get(function(req, res){
		patientService.findPatientBySSN(req.decoded, req.params.ssn, function(err, result){
			if(err)res.status(err.statusCode || 500).json(err);
			else res.json(result);
		});
	});

/**
GET patient by Last Five
**/
patientRouter.route("/five/:lastFive")
	.get(function(req, res){
		patientService.findPatientByLastFive(req.decoded, req.params.lastFive, function(err, result){
			if(err)res.status(err.statusCode || 500).json(err);
			else res.json(result);
		});
	});

/**
 GET patient by name
 **/
patientRouter.route("/name/:name")
    .get(function(req, res){
        patientService.findPatientByName(req.decoded, req.params.name, function(err, result){
            if(err)res.status(err.statusCode || 500).json(err);
            else res.json(result);
        });
    });

/**
GET patient data
**/
patientRouter.route("/:id")
	.get(function(req, res){
        patientService.selectPatientById(req.decoded, req.params.id, function(err, result){
			if(err)res.status(err.statusCode || 500).json(err);
			else res.json(result);
		});
	});

/**
GET Patient Record
*/
patientRouter.route("/record/:id")
	.get(function(req, res){
		patientService.getVirtualPatientRecord(req.decoded, req.params.id, null, function(err, result){
			if(err)res.status(err.statusCode || 500).json(err);
			else res.json(result);
		});
	});

/**************************
 *   Patient Case Routes  *
 **************************/
/**
 * GET All Patient Cases
 */
patientRouter.route("/:id/cases")
	.get(function(req, res){
        caseService.searchCases(req.decoded, {"pateintId": req.params.id}, function(err, result){
		//caseService.findJBPatientCases(req.decoded, req.params.id, function(err, result){
			if(err){res.status(err.statusCode || 500).json(err);}
			else {res.json(result);}
        });
	});

/**
 * GET Patient Requested Cases
 */
patientRouter.route("/:id/cases/placeholder")
    .get(function(req, res){
        caseService.searchCases(req.decoded, {"pateintId": req.params.id, "caseType":"PLACEHOLDER"}, function(err, result){
            if(err){res.status(err.statusCode || 500).json(err);}
            else {res.json(result);}
        });
    });

/**
 * GET Patient OR Cases
 */
patientRouter.route("/:id/cases/or")
    .get(function(req, res){
        caseService.searchCases(req.decoded,  {"pateintId": req.params.id, "caseType":"OR"}, function(err, result){
            if(err){res.status(err.statusCode || 500).json(err);}
            else {res.json(result);}
        });
    });

/**
 * GET Patient OR Cases By date range
 */
patientRouter.route("/:id/cases/or/:startdate/:enddate")
    .get(function(req, res){
        var start = new Date(req.params.startdate);
        var end = new Date(req.params.enddate);

        // Modify date to reflect correct date passed
        start.setDate(start.getDate() + 1);
        end.setDate(end.getDate() + 1);
        caseService.getPatientORCasesByDateRange(req.decoded, req.params.id, start, end, function(err, result){
            if(err){res.status(err.statusCode || 500).json(err);}
            else {res.json(result);}
        });
    });
/**
 * GET Patient Non-OR Cases
 */
patientRouter.route("/:id/cases/nor")
    .get(function(req, res){
        caseService.searchCases(req.decoded, {"pateintId": req.params.id, "caseType":"NON-OR"}, function(err, result){
            if(err){res.status(err.statusCode || 500).json(err);}
            else {res.json(result);}
        });
    });


/**
 * GET Patient Non-OR Cases
 */
patientRouter.route("/:id/cases/nor/:startdate/:enddate")
    .get(function(req, res){
        var start = new Date(req.params.startdate);
        var end = new Date(req.params.enddate);

        // Modify date to reflect correct date passed
        start.setDate(start.getDate() + 1);
        end.setDate(end.getDate() + 1);
        caseService.getPatientNonORCasesByDateRange(req.decoded, req.params.id, start, end, function(err, result){
            if(err){res.status(err.statusCode || 500).json(err);}
            else {res.json(result);}
        });
    });

/**
 * GET Specific Patient Case
 */
patientRouter.route("/:id/cases/:caseId")
    .get(function(req, res){
        caseService.findCaseById(req.decoded, req.params.caseId, function(err, result){
            if(err){res.status(err.statusCode || 500).json(err);}
            else {res.json(result);}
        });
    });

module.exports = patientRouter;