'use strict';
require('dotenv').config();
let express = require('express'),
    listRouter = express.Router();

const listService = require("../../services/rpc/list");
const listController = require("../../controller/list");

/******************
 *   List Routes  *
 ******************/

listRouter.route("/cancelReasons")
    .get(function(req, res){
        listService.getCaseCancellationReasons(req.decoded, function(err, result){
            if(err){ res.status(err.statusCode || 500).json(err);}
            else{ res.json(result);}
        });
    });

/*

 */
listRouter.route("/closureReasons")
    .get(function(req, res){
        listService.getCaseClosureReasons(req.decoded,function(err, result){
            if(err){ res.status(err.statusCode || 500).json(err);}
            else{res.json(result);}
        });
    });

/**
 * GET all people
 */
listRouter.route("/people")
    .get(function(req, res){
        listService.getAllPeople(req.decoded, function(err, result){
            if(err) {res.status(err.statusCode || 500).json(err);}
            else {res.json(result);}
        });
    });

/**
 GET all specialties
 **/
listRouter.route("/specialty")
    .get(function(req, res){
        listService.getAllSpecialties(req.decoded, function(err, result){
            if(err)res.status(err.statusCode || 500).json(err);
            else res.json(result);
        });
    });


/**
 GET all operating rooms
 **/
listRouter.route("/or/types")
    .get(function(req, res){
        listService.getAllORRoomTypes(req.decoded, function(err, result){
            if(err)res.status(err.statusCode || 500).json(err);
            else res.json(result);
        });
    });

/**
 GET all operating rooms
 **/
listRouter.route("/or")
    .get(function(req, res){
        listService.getAllORRooms(req.decoded, function(err, result){
            if(err)res.status(err.statusCode || 500).json(err);
            else res.json(result);
        });
    });


/**
 GET all Surgery Dispositions
 **/
listRouter.route("/postopCare")
    .get(function(req, res){
        listService.getSurgeryDispositions(req.decoded, function(err, result){
            if(err)res.status(err.statusCode || 500).json(err);
            else res.json(result);
        });
    });

/**
 GET all Surgery Positions
 **/
listRouter.route("/positions")
    .get(function(req, res){
        listService.getSurgeryPositions(req.decoded, function(err, result){
            if(err)res.status(err.statusCode || 500).json(err);
            else res.json(result);
        });
    });

/**
 GET all Special Equipment
 **/
listRouter.route("/special/equipment")
    .get(function(req, res){
        listService.getSpecialEquipment(req.decoded, function(err, result){
            if(err)res.status(err.statusCode || 500).json(err);
            else res.json(result);
        });
    });

/**
 GET all Surgery Positions
 **/
listRouter.route("/plannedImplants")
    .get(function(req, res){
        listService.getPlannedImplants(req.decoded, function(err, result){
            if(err)res.status(err.statusCode || 500).json(err);
            else res.json(result);
        });
    });

/**
 GET all Surgery Dispositions
 **/
listRouter.route("/special/supplies")
    .get(function(req, res){
        listService.getSpecialSupplies(req.decoded, function(err, result){
            if(err)res.status(err.statusCode || 500).json(err);
            else res.json(result);
        });
    });


/**
 GET all Special Instruments
 **/
listRouter.route("/special/instruments")
    .get(function(req, res){
        listService.getSpecialInstruments(req.decoded, function(err, result){
            if(err)res.status(err.statusCode || 500).json(err);
            else res.json(result);
        });
    });

/**
 GET all Pharmacy Items
 **/
listRouter.route("/pharmacyItems")
    .get(function(req, res){
        listService.getPharmacyItems(req.decoded, function(err, result){
            if(err)res.status(err.statusCode || 500).json(err);
            else res.json(result);
        });
    });


/**
 GET all Hospital Locations
 **/
listRouter.route("/hospitalLocations")
    .get(function(req, res){
        listService.getHospitalLocations(req.decoded, function(err, result){
            if(err)res.status(err.statusCode || 500).json(err);
            else res.json(result);
        });
    });

/**
 GET all Attending Codes
 **/
listRouter.route("/attendingCodes")
    .get(function(req, res){
        listService.getAttendingCodes(req.decoded, function(err, result){
            if(err)res.status(err.statusCode || 500).json(err);
            else res.json(result);
        });
    });

/**
 GET all Anesthesia Supervisor Codes
 **/
listRouter.route("/aneSuperCodes")
    .get(function(req, res){
        listService.getAneSuperCodes(req.decoded, function(err, result){
            if(err)res.status(err.statusCode || 500).json(err);
            else res.json(result);
        });
    });

/**
 GET all ASA Classes
 **/
listRouter.route("/asaClass")
    .get(function(req, res){
        listService.getAsaClass(req.decoded, function(err, result){
            if(err)res.status(err.statusCode || 500).json(err);
            else res.json(result);
        });
    });

/**
 GET all Medical Specialty
 **/
listRouter.route("/medicalSpecialty")
    .get(function(req, res){
        listService.getMedicalSpecialty(req.decoded, function(err, result){
            if(err)res.status(err.statusCode || 500).json(err);
            else res.json(result);
        });
    });

/**
 GET all ICD Codes
 **/
listRouter.route("/icd")
    .get(function(req, res){
        listService.getICDCodes(req.decoded, function(err, result){
            if(err)res.status(err.statusCode || 500).json(err);
            else res.json(result);
        });
    });

/**
 GET all Skin Integrity values
 **/
listRouter.route("/skin_integrity")
    .get(function(req, res){
        listController.getPreopSkinInteg(req.decoded, function(err, result){
            if(err)res.status(err.statusCode || 500).json(err);
            else res.json(result);
        });
    });

listRouter.route("/surg_trans_device")
    .get(function(req, res){
        listController.getSurgeryTransportDevice(req.decoded, function(err, result){
            if(err)res.status(err.statusCode || 500).json(err);
            else res.json(result);
        });
    });

listRouter.route("/restraint_pos_aids")
    .get(function(req, res){
        listController.getRestraintPositionAids(req.decoded, function(err, result){
            if(err)res.status(err.statusCode || 500).json(err);
            else res.json(result);
        });
    });

listRouter.route("/skin_prep_agents")
    .get(function(req, res){
        listController.getSkinPrepAgent(req.decoded, function(err, result){
            if(err)res.status(err.statusCode || 500).json(err);
            else res.json(result);
        });
    });

listRouter.route("/patient_moods")
    .get(function(req, res){
        listController.getPatientMoods(req.decoded, function(err, result){
            if(err)res.status(err.statusCode || 500).json(err);
            else res.json(result);
        });
    });

listRouter.route("/patient_conscious")
    .get(function(req, res){
        listController.getPatientConscious(req.decoded, function(err, result){
            if(err)res.status(err.statusCode || 500).json(err);
            else res.json(result);
        });
    });

listRouter.route("/disposition")
    .get(function(req, res){
        listController.getOpDisposition(req.decoded, function(err, result){
            if(err)res.status(err.statusCode || 500).json(err);
            else res.json(result);
        });
    });
listRouter.route("/electro_ground_position")
    .get(function(req, res){
        listController.getElectroGroundPosition(req.decoded, function(err, result){
            if(err)res.status(err.statusCode || 500).json(err);
            else res.json(result);
        });
    });

module.exports = listRouter;