'use strict';
require('dotenv').config();
const express = require('express'),
    cptRouter = express.Router();

const cptService = require("../../services/rpc/cpt");

cptRouter.use("/config", require("../cnf/cptConfig"));

cptRouter.route("/")
    .get(function(req, res){
        cptService.getCPTList(req.decoded, function(error, result){
            if(error){
                console.log(error);
                res.json(error);
            }
            else{
                res.json(result);
            }
        });
    });


module.exports = cptRouter;