'use strict';
require('dotenv').config();
const express = require('express'),
    sslqiReservationRouter = express.Router();

const sslqiReservationService = require("../../services/cnf/sslqiReservation");


// GET ALL
sslqiReservationRouter.route("/")
    .get(function(req, res){
        sslqiReservationService.getAll(function(error, result){
            if(error){
                console.log(error);
                res.json(error);
            }
            else{
                res.json(result);
            }
        });
    });

// CREATE
sslqiReservationRouter.route("/")
    .post(function(req, res){
        // Check for user
        if (req.body.requester === undefined){
            req.body.requester = req.decoded.access;
        }

        sslqiReservationService.create(req.body, function (error, result) {
            if (error) {
                console.log(error);
                if (error.code === 11000) {
                    res.status(409).json({
                        success: false,
                        message: "Duplicate key error: Vista ID/Classification " + req.body.vistaId + "/" + req.body.classification + " already exists.",
                        error: error.message
                    });
                }
                else {
                    res.status(400);
                    res.json(error);
                }
            }
            else {
                res.json(result);
            }
        });
    });

// GET by ID
sslqiReservationRouter.route("/:id")
    .get(function(req, res){
        sslqiReservationService.getById(req.params.id, function(error, result){
            if(error){
                console.log(error);
                res.json(error);
            }
            else{
                res.json(result);
            }
        });
    });

// EDIT
sslqiReservationRouter.route("/:id")
    .put(function(req, res){
        sslqiReservationService.edit(req.params.id, req.body, function(error, result){
            if(error){
                console.log(error);
                res.status(400);
                res.json(error);
            }
            else{
                res.json(result);
            }
        });
    });

// DELETE by ID
sslqiReservationRouter.route("/:id")
    .delete(function(req, res){
        sslqiReservationService.remove(req.params.id, function(error, result){
            if(error){
                console.log(error);
                res.json(error);
            }
            else{
                res.json(result);
            }
        });
    });

// Search
sslqiReservationRouter.route("/search")
    .post(function(req, res){
        sslqiReservationService.search(req.body, function (error, result) {
            if (error) {
                console.log(error);
                res.json(error);
            }
            else {
                res.json(result);
            }
        });
    });

module.exports = sslqiReservationRouter;