'use strict';
require('dotenv').config();
const express = require('express'),
    releaseRequestRouter = express.Router();

const releaseRequestService = require("../../services/cnf/sslqiReleaseRequest");

// GET ALL
releaseRequestRouter.route("/")
    .get(function(req, res){
        releaseRequestService.search({}, function(error, result){
            if(error){
                console.log(error);
                res.json(error);
            }
            else{
                res.json(result);
            }
        });
    });

// CREATE
releaseRequestRouter.route("/")
    .post(function(req, res){
        // Check for user
        if (req.body.requester === undefined){
            req.body.requester = req.decoded.access;
        }

        releaseRequestService.create(req.body, function (error, result) {
            if (error) {
                console.log(error);
                if (error.code === 11000) {
                    res.status(409).json({
                        success: false,
                        message: "Duplicate key error: Vista ID/Classification " + req.body.vistaId + "/" + req.body.classification + " already exists.",
                        error: error.message
                    });
                }
                else {
                    res.status(400);
                    res.json(error);
                }
            }
            else {
                res.json(result);
            }
        });
    });

// GET by ID
releaseRequestRouter.route("/:id")
    .get(function(req, res){
        releaseRequestService.getById(req.params.id, function(error, result){
            if(error){
                console.log(error);
                res.json(error);
            }
            else{
                res.json(result);
            }
        });
    });

// APPROVE
releaseRequestRouter.route("/approve/:id")
    .put(function(req, res){
        releaseRequestService.updateStatus(req.params.id, releaseRequestService.APPROVED, function(error, result){
            if(error){
                console.log(error);
                res.status(400);
                res.json(error);
            }
            else{
                res.json(result);
            }
        });
    });

// DENY
releaseRequestRouter.route("/deny/:id")
    .put(function(req, res){
        releaseRequestService.updateStatus(req.params.id, releaseRequestService.DENIED, function(error, result){
            if(error){
                console.log(error);
                res.status(400);
                res.json(error);
            }
            else{
                res.json(result);
            }
        });
    });

// EDIT
releaseRequestRouter.route("/:id")
    .put(function(req, res){
        releaseRequestService.edit(req.params.id, req.body, function(error, result){
            if(error){
                console.log(error);
                res.status(400);
                res.json(error);
            }
            else{
                res.json(result);
            }
        });
    });

// DELETE by ID
releaseRequestRouter.route("/:id")
    .delete(function(req, res){
        releaseRequestService.deleteReleaseRequest(req.params.id, function(error, result){
            if(error){
                console.log(error);
                res.json(error);
            }
            else{
                res.json(result);
            }
        });
    });


module.exports = releaseRequestRouter;