'use strict';
require('dotenv').config();
const express = require('express'),
    sslqiRouter = express.Router();

const sslqiService = require("../../services/cnf/sslqi");

sslqiRouter.use("/reservation", require("./sslqiReservation"));
sslqiRouter.use("/release", require("./sslqiReleaseRequest"));

// EXPORT
sslqiRouter.route("/export")
    .get(function(req, res){
        sslqiService.getAllSSLQI(req.decoded, function(error, result){
            if(error){
                console.log(error);
                res.json(error);
            }
            else{
                res.json(result);
            }
        });
    });

// GET by ID
sslqiRouter.route("/:id")
    .get(function(req, res){
        sslqiService.getById(req.decoded, req.params.id, function(error, result){
            if(error){
                console.log(error);
                res.json(error);
            }
            else{
                res.json(result);
            }
        });
    });

// GET by VistA ID/Classification
sslqiRouter.route("/:classification/:id")
    .get(function(req, res){
        sslqiService.getSSLQIForCriteria(req.decoded, {vistaId: req.params.id, classification: req.params.classification}, function(error, result){
            if(error){
                console.log(error);
                res.json(error);
            }
            else{
                res.json(result);
            }
        });
    });

// DELETE by ID
sslqiRouter.route("/:id")
    .delete(function(req, res){
        sslqiService.removeById(req.decoded, req.params.id, function(error, result){
            if(error){
                console.log(error);
                res.json(error);
            }
            else{
                res.json(result);
            }
        });
    });

// DELETE by VistA ID/Classification
sslqiRouter.route("/:classification/:id")
    .delete(function(req, res){
        sslqiService.removeByVistaIdClassifcation(req.decoded, req.params.id, req.params.classification, function(error, result){
            if(error){
                console.log(error);
                res.json(error);
            }
            else{
                res.json(result);
            }
        });
    });

// SEARCH by criteria
sslqiRouter.route("/search")
    .post(function(req, res){
        sslqiService.getSSLQIForCriteria(req.decoded, req.body, function(error, result){
            if(error){
                console.log(error);
                res.json(error);
            }
            else{
                res.json(result);
            }
        });
    });

// GET ALL
sslqiRouter.route("/")
    .get(function(req, res){
        sslqiService.getAllSSLQI(req.decoded, function(error, result){
            if(error){
                console.log(error);
                res.json(error);
            }
            else{
                res.json(result);
            }
        });
    });

// CREATE
sslqiRouter.route("/")
    .post(function(req, res){

        if (Object.prototype.toString.call(req.body) == '[object Array]') {
            sslqiService.importSSLQI(req.decoded, req.body, function(error, result){
                if(error){
                    console.log(error);
                    if (error.code === 11000) {
                        res.status(409).json({
                            success: false,
                            message: "Duplicate key error: Vista ID/Classification " + req.body.vistaId + "/" + req.body.class + " already exists.",
                            error: error.message
                        });
                    }
                    else{
                        res.status(400);
                        res.json(error);
                    }
                }
                else{
                    res.json(result);
                }
            });
        }
        else {
            sslqiService.create(req.decoded, req.body, function (error, result) {
                if (error) {
                    console.log(error);
                    if (error.code === 11000) {
                        res.status(409).json({
                            success: false,
                            message: "Duplicate key error: Vista ID/Classification " + req.body.vistaId + "/" + req.body.class + " already exists.",
                            error: error.message
                        });
                    }
                    else {
                        res.status(400);
                        res.json(error);
                    }
                }
                else {
                    console.log('before');
                    res.json(result);
                    console.log('after');
                }
            });
        }
    });

// IMPORT multiple SSLQI's
sslqiRouter.route("/import")
    .post(function(req, res){
        sslqiService.importSSLQI(req.decoded, req.body, function(error, result){
            if(error){
                console.log(error);
                if (error.code === 11000) {
                    res.status(409).json({
                        success: false,
                        message: "Duplicate key error: Vista ID/Classification " + req.body.vistaId + "/" + req.body.class + " already exists.",
                        error: error.message
                    });
                }
                else{
                    res.status(400);
                    res.json(error);
                }
            }
            else{
                res.json(result);
            }
        });
    });

// EDIT
sslqiRouter.route("/:classification/:id")
    .put(function(req, res){
        sslqiService.edit(req.decoded, req.body, req.params.classification, req.params.id, function(error, result){
            if(error){
                console.log(error);
                res.status(400);
                res.json(error);
            }
            else{
                res.json(result);
            }
        });
    });

// EDIT
sslqiRouter.route("/:id")
    .put(function(req, res){
        sslqiService.editById(req.decoded, req.body, req.params.id, function(error, result){
            if(error){
                console.log(error);
                res.status(400);
                res.json(error);
            }
            else{
                res.json(result);
            }
        });
    });

module.exports = sslqiRouter;