'use strict';
require('dotenv').config();
const express = require('express'),
    specialtyRoomRouter = express.Router();

const specialtyRoomService = require("../../services/cnf/specialtyRoomType");

specialtyRoomRouter.route("/room/config/:specialtyId")
    .get(function(req, res){
        specialtyRoomService.getRoomTypeConfig(req.decoded, req.params.specialtyId, function(error, result){
            if(error){
                console.log(error);
                res.json(error);
            }
            else{
                res.json(result);
            }
        });
    });

specialtyRoomRouter.route("/room/config/:specialtyId")
    .delete(function(req, res){
        specialtyRoomService.removeRoomTypeConfig(req.decoded, req.params.specialtyId, function(error, result){
            if(error){
                console.log(error);
                res.json(error);
            }
            else{
                res.json(result);
            }
        });
    });


specialtyRoomRouter.route("/room/config/search")
    .post(function(req, res){
        specialtyRoomService.getRoomForCriteria(req.decoded, req.body, function(error, result){
            if(error){
                console.log(error);
                res.json(error);
            }
            else{
                res.json(result);
            }
        });
    });


specialtyRoomRouter.route("/room/config")
    .get(function(req, res){
        specialtyRoomService.getAllConfigs(req.decoded, function(error, result){
            if(error){
                console.log(error);
                res.json(error);
            }
            else{
                res.json(result);
            }
        });
    });


specialtyRoomRouter.route("/room/config")
    .post(function(req, res){
        specialtyRoomService.create(req.body, function(error, result){
            if(error){
                console.log(error);
                if (error.code === 11000) {
                    res.status(409).json({
                        success: false,
                        message: "Duplicate key error: room ID already exists.",
                        error: error.message
                    });
                }
                else{
                    res.status(400);
                    res.json(error);
                }
            }
            else{
                console.log('before');
                res.json(result);
                console.log('after');
            }
        });
    });


specialtyRoomRouter.route("/room/config/:id")
    .put(function(req, res){
        specialtyRoomService.edit(req.body, req.params.id, function(error, result){
            if(error){
                console.log(error);
                res.status(400);
                res.json(error);
            }
            else{
                res.json(result);
            }
        });
    });


module.exports = specialtyRoomRouter;