'use strict';
require('dotenv').config();
let express = require('express'),
    setFieldRouter = express.Router();

const setFieldService = require("../../services/cnf/setField");


/**
 GET caseScheduleType
 **/
setFieldRouter.route("/caseScheduleType")
    .get(function(req, res){
        setFieldService.findByTitle(setFieldService.CASE_SCHEDULE_TYPE, function(err, result){
            if(err){res.json(err);}
            else{res.json(result);}
        });
    });

/**
 GET preOpInfection
 **/
setFieldRouter.route("/preOpInfection")
    .get(function(req, res){
        setFieldService.findByTitle(setFieldService.PRE_OP_INFECTION, function(err, result){
            if(err){res.json(err);}
            else{res.json(result);}
        });
    });

/**
 GET anesthesiaTechnique
 **/
setFieldRouter.route("/anesthesiaTechnique")
    .get(function(req, res){
        setFieldService.findByTitle(setFieldService.ANESTHESIA_TECHNIQUE, function(err, result){
            if(err){res.json(err);}
            else{res.json(result);}
        });
    });

/**
 GET admissionStatus
 **/
setFieldRouter.route("/admissionStatus")
    .get(function(req, res){
        setFieldService.findByTitle(setFieldService.ADMISSION_STATUS, function(err, result){
            if(err){res.json(err);}
            else{res.json(result);}
        });
    });

/**
 GET intraoperativeXrays
 **/
setFieldRouter.route("/intraoperativeXrays")
    .get(function(req, res){
        setFieldService.findByTitle(setFieldService.INTRAOPERATIVE_XRAYS, function(err, result){
            if(err){res.json(err);}
            else{res.json(result);}
        });
    });

/**
 GET bloodTypeXmatch
 **/
setFieldRouter.route("/bloodTypeXmatch")
    .get(function(req, res){
        setFieldService.findByTitle(setFieldService.BLOOD_TYPE_X_MATCH, function(err, result){
            if(err){res.json(err);}
            else{res.json(result);}
        });
    });

/**
 GET cancelTimeframe
 **/
setFieldRouter.route("/cancelTimeframe")
    .get(function(req, res){
        setFieldService.findByTitle(setFieldService.CANCEL_TIME_FRAME, function(err, result){
            if(err){res.json(err);}
            else{res.json(result);}
        });
    });

/**
 GET bloodProductInfo
 **/
setFieldRouter.route("/bloodProductInfo")
    .get(function(req, res){
        setFieldService.findByTitle(setFieldService.BLOOD_PRODUCT_INFO, function(err, result){
            if(err){res.json(err);}
            else{res.json(result);}
        });
    });

/**
 GET procedureLaterality
 **/
setFieldRouter.route("/procedureLaterality")
    .get(function(req, res){
        setFieldService.findByTitle(setFieldService.PROCEDURE_LATERALITY, function(err, result){
            if(err){res.json(err);}
            else{res.json(result);}
        });
    });

/**
 GET caseType
 **/
setFieldRouter.route("/case_type")
    .get(function(req, res){
        setFieldService.findByTitle(setFieldService.CASE_TYPE, function(err, result){
            if(err){res.json(err);}
            else{res.json(result);}
        });
    });

/**
 GET caseStatus
 **/
setFieldRouter.route("/case_status")
    .get(function(req, res){
        setFieldService.findByTitle(setFieldService.CASE_STATUS, function(err, result){
            if(err){res.json(err);}
            else{res.json(result);}
        });
    });

/**
 GET SSLQI classifications
 **/
setFieldRouter.route("/sslqi/classification")
    .get(function(req, res){
        setFieldService.findByTitle(setFieldService.SSLQI_CLASSIFICATION, function(err, result){
            if(err){res.json(err);}
            else{res.json(result);}
        });
    });

// -------------------------------------------------------------------------------------


setFieldRouter.route("/packing")
    .get(function(req, res){
        setFieldService.findByTitle(setFieldService.PACKING, function(err, result){
            if(err){res.json(err);}
            else{res.json(result);}
        });
    });

setFieldRouter.route("/patient_edu_assessment")
    .get(function(req, res){
        setFieldService.findByTitle(setFieldService.PATIENT_EDU_ASSESSMENT, function(err, result){
            if(err){res.json(err);}
            else{res.json(result);}
        });
    });

setFieldRouter.route("/wound_classification")
    .get(function(req, res){
        setFieldService.findByTitle(setFieldService.WOUND_CLASSIFICATION, function(err, result){
            if(err){res.json(err);}
            else{res.json(result);}
        });
    });

setFieldRouter.route("/hair_removal_method")
    .get(function(req, res){
        setFieldService.findByTitle(setFieldService.HAIR_REMOVAL_METHOD, function(err, result){
            if(err){res.json(err);}
            else{res.json(result);}
        });
    });

setFieldRouter.route("/general")
    .get(function(req, res){
        setFieldService.findByTitle(setFieldService.GENERAL, function(err, result){
            if(err){res.json(err);}
            else{res.json(result);}
        });
    });

setFieldRouter.route("/diabetes_mellitus")
    .get(function(req, res){
        setFieldService.findByTitle(setFieldService.DIABETES_MELITUS, function(err, result){
            if(err){res.json(err);}
            else{res.json(result);}
        });
    });

setFieldRouter.route("/tobacco_use")
    .get(function(req, res){
        setFieldService.findByTitle(setFieldService.TOBACCO_USE, function(err, result){
            if(err){res.json(err);}
            else{res.json(result);}
        });
    });

setFieldRouter.route("/tobacco_timeframe")
    .get(function(req, res){
        setFieldService.findByTitle(setFieldService.TOBACCO_TIMEFRAME, function(err, result){
            if(err){res.json(err);}
            else{res.json(result);}
        });
    });

setFieldRouter.route("/two_drinks_day")
    .get(function(req, res){
        setFieldService.findByTitle(setFieldService.TWO_DRINKS_PER_DAY, function(err, result){
            if(err){res.json(err);}
            else{res.json(result);}
        });
    });

setFieldRouter.route("/positive_drug_screening")
    .get(function(req, res){
        setFieldService.findByTitle(setFieldService.POSITIVE_DR_SCRN, function(err, result){
            if(err){res.json(err);}
            else{res.json(result);}
        });
    });

setFieldRouter.route("/dyspnea")
    .get(function(req, res){
        setFieldService.findByTitle(setFieldService.DYSPNEA, function(err, result){
            if(err){res.json(err);}
            else{res.json(result);}
        });
    });

setFieldRouter.route("/preop_sleep_apnea")
    .get(function(req, res){
        setFieldService.findByTitle(setFieldService.PREOP_SLEEP_APNEA, function(err, result){
            if(err){res.json(err);}
            else{res.json(result);}
        });
    });

setFieldRouter.route("/dnr_status")
    .get(function(req, res){
        setFieldService.findByTitle(setFieldService.DNR_STATUS, function(err, result){
            if(err){res.json(err);}
            else{res.json(result);}
        });
    });

setFieldRouter.route("/functional_health_status")
    .get(function(req, res){
        setFieldService.findByTitle(setFieldService.FUNCTIONAL_HEALTH_STATUS, function(err, result){
            if(err){res.json(err);}
            else{res.json(result);}
        });
    });

setFieldRouter.route("/residence")
    .get(function(req, res){
        setFieldService.findByTitle(setFieldService.RESIDENCE, function(err, result){
            if(err){res.json(err);}
            else{res.json(result);}
        });
    });

setFieldRouter.route("/ambulation_device")
    .get(function(req, res){
        setFieldService.findByTitle(setFieldService.AMBULATION_DEVICE, function(err, result){
            if(err){res.json(err);}
            else{res.json(result);}
        });
    });

setFieldRouter.route("/homeless")
    .get(function(req, res){
        setFieldService.findByTitle(setFieldService.HOMELESS, function(err, result){
            if(err){res.json(err);}
            else{res.json(result);}
        });
    });

setFieldRouter.route("/pulmonary")
    .get(function(req, res){
        setFieldService.findByTitle(setFieldService.PULMONARY, function(err, result){
            if(err){res.json(err);}
            else{res.json(result);}
        });
    });

setFieldRouter.route("/ventilator_dependent")
    .get(function(req, res){
        setFieldService.findByTitle(setFieldService.VENTILATOR_DEPENDENT, function(err, result){
            if(err){res.json(err);}
            else{res.json(result);}
        });
    });

setFieldRouter.route("/copd_history")
    .get(function(req, res){
        setFieldService.findByTitle(setFieldService.COPD_HISTORY, function(err, result){
            if(err){res.json(err);}
            else{res.json(result);}
        });
    });

setFieldRouter.route("/current_pneumonia")
    .get(function(req, res){
        setFieldService.findByTitle(setFieldService.CURRENT_PNEUMONIA, function(err, result){
            if(err){res.json(err);}
            else{res.json(result);}
        });
    });

setFieldRouter.route("/hepatobiliary")
    .get(function(req, res){
        setFieldService.findByTitle(setFieldService.HEPATOBILIARY, function(err, result){
            if(err){res.json(err);}
            else{res.json(result);}
        });
    });

setFieldRouter.route("/ascites")
    .get(function(req, res){
        setFieldService.findByTitle(setFieldService.ASCITES, function(err, result){
            if(err){res.json(err);}
            else{res.json(result);}
        });
    });

setFieldRouter.route("/gastrointestinal")
    .get(function(req, res){
        setFieldService.findByTitle(setFieldService.GASTROINTESTINAL, function(err, result){
            if(err){res.json(err);}
            else{res.json(result);}
        });
    });

setFieldRouter.route("/esophageal_varices")
    .get(function(req, res){
        setFieldService.findByTitle(setFieldService.ESOPHAGEAL_VARICES, function(err, result){
            if(err){res.json(err);}
            else{res.json(result);}
        });
    });

setFieldRouter.route("/congestive_heart_failure_preop")
    .get(function(req, res){
        setFieldService.findByTitle(setFieldService.CONGESTIVE_HEART_FAILURE_PREOP, function(err, result){
            if(err){res.json(err);}
            else{res.json(result);}
        });
    });

setFieldRouter.route("/cardiac")
    .get(function(req, res){
        setFieldService.findByTitle(setFieldService.CARDIAC, function(err, result){
            if(err){res.json(err);}
            else{res.json(result);}
        });
    });

setFieldRouter.route("/prior_mi")
    .get(function(req, res){
        setFieldService.findByTitle(setFieldService.PRIOR_MI, function(err, result){
            if(err){res.json(err);}
            else{res.json(result);}
        });
    });

setFieldRouter.route("/pci")
    .get(function(req, res){
        setFieldService.findByTitle(setFieldService.PCI, function(err, result){
            if(err){res.json(err);}
            else{res.json(result);}
        });
    });

setFieldRouter.route("/angina_timeframe")
    .get(function(req, res){
        setFieldService.findByTitle(setFieldService.ANGINA_TIMEFRAME, function(err, result){
            if(err){res.json(err);}
            else{res.json(result);}
        });
    });

setFieldRouter.route("/angina_severity")
    .get(function(req, res){
        setFieldService.findByTitle(setFieldService.ANGINA_SEVERITY, function(err, result){
            if(err){res.json(err);}
            else{res.json(result);}
        });
    });

setFieldRouter.route("/hypertension")
    .get(function(req, res){
        setFieldService.findByTitle(setFieldService.HYPERTENSION, function(err, result){
            if(err){res.json(err);}
            else{res.json(result);}
        });
    });

setFieldRouter.route("/prior_surg_same_op_field")
    .get(function(req, res){
        setFieldService.findByTitle(setFieldService.PRIOR_SURG_SAME_OP_FIELD, function(err, result){
            if(err){res.json(err);}
            else{res.json(result);}
        });
    });

setFieldRouter.route("/hx_rad_rx_planned_surg_field")
    .get(function(req, res){
        setFieldService.findByTitle(setFieldService.HX_RAD_RX_PLANNED_SURG_FIELD, function(err, result){
            if(err){res.json(err);}
            else{res.json(result);}
        });
    });

setFieldRouter.route("/donor_serology")
    .get(function(req, res){
        setFieldService.findByTitle(setFieldService.DONOR_SEROLOGY, function(err, result){
            if(err){res.json(err);}
            else{res.json(result);}
        });
    });

setFieldRouter.route("/vascular")
    .get(function(req, res){
        setFieldService.findByTitle(setFieldService.VASCULAR, function(err, result){
            if(err){res.json(err);}
            else{res.json(result);}
        });
    });

setFieldRouter.route("/peripheral_arterial_disease")
    .get(function(req, res){
        setFieldService.findByTitle(setFieldService.PERIPHERAL_ARTERIAL_DISEASE, function(err, result){
            if(err){res.json(err);}
            else{res.json(result);}
        });
    });

setFieldRouter.route("/rest_pain_gaingrene")
    .get(function(req, res){
        setFieldService.findByTitle(setFieldService.REST_PAIN_GAINGRENE, function(err, result){
            if(err){res.json(err);}
            else{res.json(result);}
        });
    });

setFieldRouter.route("/renal")
    .get(function(req, res){
        setFieldService.findByTitle(setFieldService.RENAL, function(err, result){
            if(err){res.json(err);}
            else{res.json(result);}
        });
    });

setFieldRouter.route("/renal_failure")
    .get(function(req, res){
        setFieldService.findByTitle(setFieldService.RENAL_FAILURE, function(err, result){
            if(err){res.json(err);}
            else{res.json(result);}
        });
    });

setFieldRouter.route("/on_dialysis")
    .get(function(req, res){
        setFieldService.findByTitle(setFieldService.ON_DIALYSIS, function(err, result){
            if(err){res.json(err);}
            else{res.json(result);}
        });
    });

setFieldRouter.route("/central_nerv_sys_illness")
    .get(function(req, res){
        setFieldService.findByTitle(setFieldService.CENTRAL_NERV_SYS_ILLNESS, function(err, result){
            if(err){res.json(err);}
            else{res.json(result);}
        });
    });

setFieldRouter.route("/impaired_sensorium")
    .get(function(req, res){
        setFieldService.findByTitle(setFieldService.IMPAIRED_SENSORIUM, function(err, result){
            if(err){res.json(err);}
            else{res.json(result);}
        });
    });

setFieldRouter.route("/coma")
    .get(function(req, res){
        setFieldService.findByTitle(setFieldService.COMA, function(err, result){
            if(err){res.json(err);}
            else{res.json(result);}
        });
    });

setFieldRouter.route("/hemiplegia_hemiparesis")
    .get(function(req, res){
        setFieldService.findByTitle(setFieldService.HEMIPLEGIA_HEMIPARESES, function(err, result){
            if(err){res.json(err);}
            else{res.json(result);}
        });
    });

setFieldRouter.route("/history_of_cvd")
    .get(function(req, res){
        setFieldService.findByTitle(setFieldService.HISTORY_OF_CVD, function(err, result){
            if(err){res.json(err);}
            else{res.json(result);}
        });
    });

setFieldRouter.route("/tumor_involving_cns")
    .get(function(req, res){
        setFieldService.findByTitle(setFieldService.CNS_TUMOR, function(err, result){
            if(err){res.json(err);}
            else{res.json(result);}
        });
    });

setFieldRouter.route("/impaired_cognitive_function")
    .get(function(req, res){
        setFieldService.findByTitle(setFieldService.IMPAIRED_COGNITIVE_FUNCTION, function(err, result){
            if(err){res.json(err);}
            else{res.json(result);}
        });
    });

setFieldRouter.route("/nutritional_immune_other")
    .get(function(req, res){
        setFieldService.findByTitle(setFieldService.NUTRITIONAL_IMMUNE_OTHER, function(err, result){
            if(err){res.json(err);}
            else{res.json(result);}
        });
    });

setFieldRouter.route("/disseminated_cancer")
    .get(function(req, res){
        setFieldService.findByTitle(setFieldService.DISSEMINATED_CANCER, function(err, result){
            if(err){res.json(err);}
            else{res.json(result);}
        });
    });

setFieldRouter.route("/open_wound")
    .get(function(req, res){
        setFieldService.findByTitle(setFieldService.OPEN_WOUND, function(err, result){
            if(err){res.json(err);}
            else{res.json(result);}
        });
    });

setFieldRouter.route("/chronic_steroid_use")
    .get(function(req, res){
        setFieldService.findByTitle(setFieldService.CHRONIC_STEROID_USE, function(err, result){
            if(err){res.json(err);}
            else{res.json(result);}
        });
    });

setFieldRouter.route("/ten_perc_weight_loss")
    .get(function(req, res){
        setFieldService.findByTitle(setFieldService.TEN_PERC_WEIGHT_LOSS, function(err, result){
            if(err){res.json(err);}
            else{res.json(result);}
        });
    });

setFieldRouter.route("/bleeding_disorders")
    .get(function(req, res){
        setFieldService.findByTitle(setFieldService.BLEEDING_DISORDERS, function(err, result){
            if(err){res.json(err);}
            else{res.json(result);}
        });
    });

setFieldRouter.route("/medication_bleeding_risk")
    .get(function(req, res){
        setFieldService.findByTitle(setFieldService.MED_BLEEDING_RISK, function(err, result){
            if(err){res.json(err);}
            else{res.json(result);}
        });
    });

setFieldRouter.route("/transfusion_gt_four_rbcs")
    .get(function(req, res){
        setFieldService.findByTitle(setFieldService.TRANSFUSION_GT_FOUR_RBCS, function(err, result){
            if(err){res.json(err);}
            else{res.json(result);}
        });
    });

setFieldRouter.route("/malig_chemo")
    .get(function(req, res){
        setFieldService.findByTitle(setFieldService.MAILG_CHEMO, function(err, result){
            if(err){res.json(err);}
            else{res.json(result);}
        });
    });

setFieldRouter.route("/radio_therapy_last_ninety")
    .get(function(req, res){
        setFieldService.findByTitle(setFieldService.RADIO_THERAPY_LAST_NINETY, function(err, result){
            if(err){res.json(err);}
            else{res.json(result);}
        });
    });

setFieldRouter.route("/preop_sepsis")
    .get(function(req, res){
        setFieldService.findByTitle(setFieldService.PREOP_SEPSIS, function(err, result){
            if(err){res.json(err);}
            else{res.json(result);}
        });
    });

setFieldRouter.route("/pregnancy")
    .get(function(req, res){
        setFieldService.findByTitle(setFieldService.PREGNANCY, function(err, result){
            if(err){res.json(err);}
            else{res.json(result);}
        });
    });

setFieldRouter.route("/assessment_type")
    .get(function(req, res){
        setFieldService.findByTitle(setFieldService.ASSESSMENT_TYPE, function(err, result){
            if(err){res.json(err);}
            else{res.json(result);}
        });
    });



module.exports = setFieldRouter;
