/**
 * Role Route
 * @author atignola
 */

'use strict';
require('dotenv').config();
let express = require('express'),
    roleRouter = express.Router();

const roleService = require("../../services/cnf/role");

/**
 * GET list of roles
 */
roleRouter.route("/")
    .get(function(req, res){
        roleService.getAllRoles(function(err, result){
            if (err) { res.status(400).json(err); }
            else { res.json(result); }
        });
    });


/**
 * GET create new role
 */
roleRouter.route("/")
    .post(function(req, res){
        roleService.create(req.body, function(err, result){
            if (err) {res.status(400).json(err); }
            else { res.json(result); }
        });
    });

/**
 * POST edit existing template case
 */
roleRouter.route("/:id")
    .put(function(req, res){
        roleService.edit(req.params.id, req.body, function(err, result){
            if (err){res.status(400).json(err);}
            else { res.json(result); }
        });
    });

/**
 * DELETE an existing template case
 */
roleRouter.route("/:id")
    .delete(function(req, res){
        roleService.remove(req.params.id, function(err, result){
            if (err) { res.status(400).json(err); }
            else { res.json(result); }
        });
    });

/**
 * GET list of role names
 */
roleRouter.route("/list/names")
    .get(function(req, res){
        roleService.getRoleNamesList(function(err, result){
            if (err) { res.status(400).json(err); }
            else { res.json(result); }
        });
    });

/**
 * GET list of role keys
 */
roleRouter.route("/list/keys/")
    .get(function(req, res){
        roleService.getKeysList(function(err, result){
            if (err) { res.status(400).json(err); }
            else { res.json(result); }
        });
    });


/**
 GET  roles by id
 **/
roleRouter.route("/:id")
    .get(function(req, res){
        roleService.getRoleById(req.params.id, function(err, result){
            if(err){res.status(400).json(err);}
            else{res.json(result);}
        });
    });

/**
 GET  roles by key
 **/
roleRouter.route("/:key")
    .get(function(req, res){
        roleService.getRolesByKey(req.params.key, function(err, result){
            if(err){res.status(400).json(err);}
            else{res.json(result);}
        });
    });



module.exports = roleRouter;