/**
 * Role Route
 * @author rgokulnath
 */

'use strict';
require('dotenv').config();
let express = require('express'),
    providerRouter = express.Router();

const providerService = require("../../services/cnf/provider");

/**
 * GET work times for a provider
 */
providerRouter.route("/:ien")
    .get(function(req, res){
        providerService.getProviderWorkTime(req.params.ien, function(err, result){
            if (err) { res.status(404).json(err); }
            else { res.json(result); }
        });
    });

/**
* PUT a new timing and provider
*/
providerRouter.route("/")
	.put(function(req, res){
		providerService.updateProviderWorkTime(req.body, function(result){
			if(result.err) {
				console.log("Coming back with err: ",result.err);
				res.status(500).json(result.err);
			}
			else{res.status(200).json(result);}
		});
	});

module.exports = providerRouter;