'use strict';
require('dotenv').config();
const express = require('express'),
    procedureCategoryRouter = express.Router();

const procedureCategoryService = require("../../services/cnf/nameDescription");

/**
 * POST procedureCategory
 */
procedureCategoryRouter.route("/")
    .post (function(req, res){
        let data = req.body;
        data["category"] = procedureCategoryService.PROCEDURE_CATEGORY_CATEGORY;
        procedureCategoryService.createNameDescription(data, function(err, result){
            if(err){ res.status(500).json(err);}
            else{ res.json(result);}
        });
    });

/**
 * GET all procedureCategory
 */
procedureCategoryRouter.route("/")
    .get (function(req, res){
        procedureCategoryService.getNameDescriptionByCategory(procedureCategoryService.PROCEDURE_CATEGORY_CATEGORY, function(err, result){
            if(err){ res.status(500).json(err);}
            else if (result === undefined || result === null){
                res.status(400).json("Error: No procedure category exists.");
            }
            else {
                res.json(result);
            }
        });
    });

/**
 * GET procedureCategory by id
 */
procedureCategoryRouter.route("/:id")
    .get (function(req, res){
        procedureCategoryService.getNameDescriptionByIdCategory(req.params.id, procedureCategoryService.PROCEDURE_CATEGORY_CATEGORY, function(err, result){
            if(err){ res.status(500).json(err);}
            else if (result === undefined || result === null){
                res.status(400).json("Error: No procedure category exists for the specified ID: " + req.params.id);
            }
            else {
                res.json(result);
            }
        });
    });

/**
 * PUT Edit an existing procedureCategory
 */
procedureCategoryRouter.route("/:id")
    .put (function(req, res){
        procedureCategoryService.editNameDescription(req.params.id, procedureCategoryService.PROCEDURE_CATEGORY_CATEGORY, req.body, function(err, result){
            if(err){ res.status(500).json(err);}
            else if (result === undefined || result === null){
                res.status(400).json("Error: No procedure category exists for the specified ID: " + req.params.id );
            }
            else {
                res.json(result);
            }
        });
    });

/**
 * DELETE an existing procedureCategory
 */
procedureCategoryRouter.route("/:id")
    .delete (function(req, res){
        procedureCategoryService.removeNameDescription(req.params.id, procedureCategoryService.PROCEDURE_CATEGORY_CATEGORY, function(err, result){
            if(err){ res.status(500).json(err);}
            else if (result === undefined || result === null){
                res.status(400).json("Error: No procedure category exists for the specified ID: " + req.params.id );
            }
            else {
                res.json(result);
            }
        });
    });


module.exports = procedureCategoryRouter;