/**
 * notification Route
 * @author rgokulnath
 */

'use strict';
require('dotenv').config();
let express = require('express'),
    notificationRouter = express.Router();

const notificationService = require("../../services/cnf/notification");

/**
 * GET all notifications for a user
 */
notificationRouter.route("/:user_ien")
    .get(function(req, res){
        notificationService.getNotifications(req.params.user_ien, function(err, result){
            if (err) { res.status(404).json(err); }
            else { res.json(result); }
        });
    });

function addNotification(req, res){
		notificationService.addNotification(req.body, function(result){
			if(result.err) {
				console.log("Coming back with err: ",result.err);
				res.status(500).json(result.err);
			}
			else{res.status(200).json(result);}
		});
	}

/**
* PUT a new timing and provider
*/
notificationRouter.route("/").put(addNotification);
notificationRouter.route("/").post(addNotification);

module.exports = notificationRouter;