'use strict';
require('dotenv').config();
const express = require('express'),
    extendedCaseRouter = express.Router();

const caseService = require("../../services/rpc/case");
const caseController = require("../../controller/case");

/**
 * POST Extend Case endtime
 */
extendedCaseRouter.route("/")
    .post (function(req, res){
        caseController.extendCaseEndTime(req.decoded, req.body, function(err, result){
            if(err){ res.status(400).json(err);}
            else{res.json(result);}
        });
    });

/**
 * GET Extend Case endtime by vista id
 */
extendedCaseRouter.route("/")
    .get (function(req, res){
        caseController.getAllExtendedCases(function(err, result){
            if(err){ res.status(404).json(err);}
            else{res.json(result);}
        });
    });

/**
 * GET Extend Case endtime by vista id
 */
extendedCaseRouter.route("/:vistaId")
    .get (function(req, res){
        caseController.findExtendedCaseByVistaId(req.params.vistaId, function(err, result){
            if(err){ res.status(404).json(err);}
            else{res.json(result);}
        });
    });

/**
 * PUT Edit an existing extendedCase by vista id
 */
extendedCaseRouter.route("/:vistaId")
    .put (function(req, res){
        caseController.editExtendedCase(req.params.vistaId, req.body, function(err, result){
            if(err){ res.status(400).json(err);}
            else{res.json(result);}
        });
    });

/**
 * PUT Edit an existing extendedCase by vista id
 */
extendedCaseRouter.route("/:vistaId")
    .delete (function(req, res){
        caseController.removeExtendedCase(req.params.vistaId, function(err, result){
            if(err){ res.status(400).json(err);}
            else{res.json(result);}
        });
    });


module.exports = extendedCaseRouter;