/**
 * CPTConfig Route
 * @author atignola
 */

'use strict';
require('dotenv').config();
let express = require('express'),
    cptConfigRouter = express.Router();

const cptConfigService = require("../../services/cnf/cptConfig");
const cptConfigController = require("../../controller/cptConfig");
/**
 * POST search for CPTConfig
 */
cptConfigRouter.route("/search")
    .post(function(req, res){
        cptConfigService.search(req.body, function(err, result){
            if (err) {res.status(400).json(err); }
            else { res.json(result); }
        });
    });

/**
 * GET list of CPTConfigs
 */
cptConfigRouter.route("/")
    .get(function(req, res){
        cptConfigService.getAllCPTConfigs(function(err, result){
            if (err) { res.status(400).json(err); }
            else { res.json(result); }
        });
    });

/**
 * POST create new CPTConfig
 */
cptConfigRouter.route("/")
    .post(function(req, res){
        cptConfigService.create(req.body, function(err, result){
            if (err) {res.status(400).json(err); }
            else { res.json(result); }
        });
    });

/**
 * PUT edit existing template case
 */
cptConfigRouter.route("/:cptCode")
    .put(function(req, res){
        cptConfigService.edit(req.params.cptCode, req.body, function(err, result){
            if (err){res.status(400).json(err);}
            else { res.json(result); }
        });
    });

/**
 * DELETE an existing CPT Config
 */
cptConfigRouter.route("/:cptCode")
    .delete(function(req, res){
        cptConfigService.remove(req.params.cptCode, function(err, result){
            if (err) { res.status(400).json(err); }
            else { res.json(result); }
        });
    });

/**
 * GET list CPTConfig - duration by CPT Code
 */
cptConfigRouter.route("/duration/search")
    .post(function(req, res){
        cptConfigService.getDurations(req.body, function(err, result){
            if (err) { res.status(400).json(err); }
            else { res.json(result); }
        });
    });

/**
 * GET list CPTConfig - duration by CPT Code
 */
cptConfigRouter.route("/duration/calculate")
    .get(function(req, res){
        cptConfigController.updateCPTDurations(req.decoded);
        res.json("SUCCESS");
    });

/**
 * GET list CPTConfig - duration by CPT Code
 */
cptConfigRouter.route("/duration/calculate/:cptCode")
    .post(function(req, res){
        // Check body
        let body = req.body;
        if (body === undefined || body === null || body == "") {
            body = {"cptCode": req.params.cptCode};
        }
        else if (body.cptCode === undefined || body.cptCode === null || body.cptCode == ""){
            body["cptCode"] = req.params.cptCode;
        }

        cptConfigController.updateSpecificCPTDurations(req.decoded, body, function(err, result) {
            if (err) {
                res.status(500).json(err);
            }
            else {
                res.json("SUCCESS");
            }
        });
    });


/**
 * GET list CPTConfig - duration by CPT Code
 */
cptConfigRouter.route("/duration/:cptCode")
    .get(function(req, res){
        cptConfigService.getDurationByCPT(req.params.cptCode, function(err, result){
            if (err) { res.status(400).json(err); }
            else { res.json(result); }
        });
    });

/**
 GET  CPTConfigs by CPT code
 **/
cptConfigRouter.route("/:cptCode")
    .get(function(req, res){
        cptConfigService.getByCPTCode(req.params.cptCode, function(err, result){
            if(err){res.status(400).json(err);}
            else{res.json(result);}
        });
    });


module.exports = cptConfigRouter;