/**
 API_v1.js

 All Api routes will go here
 **/
'use strict';
require('dotenv').config();
let express = require('express');
let v1 = express.Router();
// import the controllers here


/**
 Single way of doing all the HTTP verb(s)
 **/

// set configuration router paths
v1.use("/config", require("./cnf/config"));
v1.use("/facilities", require("./cnf/site"));
v1.use("/roles", require("./cnf/role"));
v1.use("/specialty", require("./cnf/specialtyRoomType"));
v1.use("/field", require("./cnf/setField"));
v1.use("/sslqi", require("./cnf/sslqi"));
v1.use("/procedure_category", require("./cnf/procedureCategory"));
v1.use("/provider", require("./cnf/provider"));
v1.use("/notification", require("./cnf/notification"));
v1.use("/report", require("./cnf/report"));

// set rpc router paths
v1.use("/patient", require("./rpc/patient"));
v1.use("/cases", require("./rpc/case"));
v1.use("/cases/placeholder", require("./rpc/placeholderCase"));
v1.use("/cpt", require("./rpc/cpt"));
v1.use("/room", require("./rpc/room"));
v1.use("/list", require("./rpc/list"));



module.exports = v1;