validator = {
    fullCase: {
        id: "/FullCase",
        type: "object",
        properties: {
            ien: {
                "type": ["string","integer"],
                "pattern": "[@]|^$|^[1-9][0-9]*$"
            },   // UNIQUE IDENTIFIER
            patient: {
                "description": "positive integer or digit string",
                "type": ["string","integer"],
                "pattern": "[@]|^$|^[1-9][0-9]*$",
                "required": true
            },   // POINTER
            hospitalAdmissionStatus: {"type": ["null", {"enum": ["", "@", "1", "2", "3"]}]},    // SET
            serviceConnected: {"type": ["null", {"enum": ["", "@", "1", "0"]}]},    // SET
            associatedClinic: {
                "type": ["string","integer"],
                "pattern": "[@]|^$|^[1-9][0-9]*$"
            },   // POINTER
            resSupCode: {
                "type": ["string","integer"],
                "pattern": "[@]|^$|^[1-9][0-9]*$"
            },   // POINTER
            anesCareTimeBlock: {"type": ["string","array"], "pattern": "[@]|^$"},    // MULTIPLE
            generalComments: {"type": ["string", "null"]},
            princAnesthetist: {
                "type": ["string","integer"],
                "pattern": "[@]|^$|^[1-9][0-9]*$"
            },   // POINTER
            anesthesiologistSupvr: {
                "type": ["string","integer"],
                "pattern": "[@]|^$|^[1-9][0-9]*$"
            },   // POINTER
            anesSuperviseCode: {
                "type": ["string","integer"],
                "pattern": "[@]|^$|^[1-9][0-9]*$"
            },   // POINTER
            anesthesiaTechnique: {"type": ["null", "array", {"enum": ["", "@", "L", "S", "B", "G", "C", "MAC", "E"]}]},    // SET
            otherProcedures: {"type": ["string","array"], "pattern": "[@]|^$"},    // MULTIPLE
            plannedPostopCare: {
                "type": ["string","integer"],
                "pattern": "[@]|^$|^[1-9][0-9]*$"
            },   // POINTER
            otherPostopDiags: {"type": ["string","array"], "pattern": "[@]|^$"},    // MULTIPLE
            caseCreateDate: {"type": ["string", "null", "NaN"]}, // DATE
            asaClass: {
                "type": ["string","integer"],
                "pattern": "[@]|^$|^[1-9][0-9]*$"
            },   // POINTER
            cancelDate: {"type": ["string", "null", "NaN"]}, // DATE
            primaryCancelReason: {
                "type": ["string","integer", "null"],
                "pattern": "[@]|^$|^[1-9][0-9]*$"
            },   // POINTER
            diagnosticTherapeutic: {"type": ["null", {"enum": ["", "@", "Y", "N"]}]},    // SET
            principalProcedure: {
                "type": ["string", "null"],
                "required": true
            },
            plannedPrincOpProcCPT: {
                "type": ["string","integer"],
                "pattern": "[@]|^$|^[1-9][0-9]*$"
            },   // POINTER
            principalDiagnosis: {"type": ["string", "null"]},
            specimens: {"type": ["string", "null"]},
            operationIndications: {"type": ["string", "null"]},
            operativeFindings: {"type": ["string", "null"]},
            briefClinHistory: {"type": ["string", "null"]},
            plannedPrinDiagCode: {
                "type": ["string","integer"],
                "pattern": "[@]|^$|^[1-9][0-9]*$"
            },   // POINTER
            location: {
                "type": ["string","integer"],
                "pattern": "[@]|^$|^[1-9][0-9]*$"
            },   // POINTER
            procedureDate: {"type": ["string", "null", "NaN"]},  // DATE
            procedureStartTime: {"type": ["string", "null", "NaN"]}, // DATE
            procedureEndTime: {"type": ["string", "null", "NaN"]},   // DATE
            provider: {
                "type": ["string","integer"],
                "pattern": "[@]|^$|^[1-9][0-9]*$"
            },   // POINTER
            attendingProvider: {
                "type": ["string","integer"],
                "pattern": "[@]|^$|^[1-9][0-9]*$"
            },   // POINTER
            medicalSpecialty: {
                "type": ["string","integer"],
                "pattern": "[@]|^$|^[1-9][0-9]*$"
            },   // POINTER
            procedureOccurence: {"type": ["string","array"], "pattern": "[@]|^$"},
            procedureLaterality: {"type": ["null", {"enum": ["", "@", "1", "2", "3", "4"]}]},    // SET
            dictatedSummary: {"type": ["null", {"enum": ["", "@", "1", "0"]}]},    // SET
            cancelComments: {"type": ["string", "null"]},
            cancelTimeframe: {"type": ["null", {"enum": ["", "@", "1", "2"]}]},    // SET,
            caseScheduleType: {"type": ["null", {"enum": ["", "@", "EM", "EL", "A", "S", "U"]}]},   // SET
            concurrentCase: {
                "type": ["string","integer"],
                "pattern": "[@]|^$|^[1-9][0-9]*$"
            },   // POINTER
            dateOfOperation: {
                "type": ["string", "null", "NaN"],
                "required": true
            },    //DATE
            nonOrFlag: {"type": ["null", {"enum": ["", "@", "Y"]}]},    // SET
            orRoom: {
                "type": ["string","integer"],
                "pattern": "[@]|^$|^[1-9][0-9]*$"
            },   // POINTER
            principalPreOpDiagnosis: {"type": ["string", "null"]},
            reqAneTechnique: {"type": ["string", "null"]},
            surgeryPosition: {"type": ["string","array"], "pattern": "[@]|^$"},    // MULTIPLE   // POINTER-MULTIPLE
            plannedAdmissionStatus: {"type": ["null", {"enum": ["", "@", "1", "2", "3"]}]},    // SET
            caseScheduleOrder: {"type": ["string", "null"]},
            surgerySpecialty: {
                "type": ["string","integer"],
                "pattern": "[@]|^$|^[1-9][0-9]*$"
            },   // POINTER
            preOpInfection: {"type": ["null", {"enum": ["", "@", "C", "D", "S"]}]},  // SET
            primarySurgeon: {
                "type": ["string","integer"],
                "pattern": "[@]|^$|^[1-9][0-9]*$"
            },   // POINTER
            firstAsst: {
                "type": ["string","integer"],
                "pattern": "[@]|^$|^[1-9][0-9]*$"
            },   // POINTER
            secondAsst: {
                "type": ["string","integer"],
                "pattern": "[@]|^$|^[1-9][0-9]*$"
            },   // POINTER
            attendingSurgeon: {
                "type": ["string","integer"],
                "pattern": "[@]|^$|^[1-9][0-9]*$"
            },   // POINTER
            otherPreopDiagnosis: {
                "type": ["string","array"],
                "pattern": "[@]|^$"
            },    // MULTIPLE
            reqFrozSect: {"type": ["null", {"enum": ["", "@", "Y", "N"]}]},    // SET
            reqPreopXray: {"type": ["string", "null"]},
            intraoperativeXrays: {"type": ["null", {"enum": ["", "@", "Y", "N", "C"]}]},  // SET
            reqPhoto: {"type": ["null", {"enum": ["", "@", "Y", "N"]}]},    // SET
            reqBloodKind: {"type": ["string","array"], "pattern": "[@]|^$"},    // MULTIPLE
            referringPhysician: {"type": ["string","array"], "pattern": "[@]|^$"},    // MULTIPLE
            prinPreOpDiagICD: {
                "type": ["string","integer"],
                "pattern": "[@]|^$|^[1-9][0-9]*$"
            },   // POINTER
            requestBloodAvailability: {"type": ["null", {"enum": ["", "@", "Y", "N"]}]},    // SET
            bloodProductInfo: {"type": ["null", {"enum": ["", "@", "T", "S", "A"]}]},    // SET
            preAdmissionTesting: {"type": ["null", {"enum": ["", "@", "Y", "N"]}]},    // SET
            palliation: {"type": ["null", {"enum": ["", "@", "Y", "N"]}]},    // SET
            specialEquipment: {"type": ["string","array"], "pattern": "[@]|^$"},   // POINTER-MULTIPLE
            plannedProsthImplant: {"type": ["string","array"], "pattern": "[@]|^$"},   // POINTER-MULTIPLE
            specialSupplies: {"type": ["string","array"], "pattern": "[@]|^$"},   // POINTER-MULTIPLE
            specialInstruments: {"type": ["string","array"], "pattern": "[@]|^$"},   // POINTER-MULTIPLE
            pharmacyItems: {"type": ["string","array"], "pattern": "[@]|^$"},   // POINTER-MULTIPLE
            bloodTypeXmatch: {"type": ["null", {"enum": ["", "@", "Y", "N", "I"]}]},    // SET
            scheduledEndTime: {"type": ["string", "null", "NaN"]},   // DATE
            scheduledStartTime: {"type": ["string", "null", "NaN"]}, // DATE
            spinalLevel: {"type": ["string", "null"]},
            surgeryScheduler: {
                "type": ["string","integer"],
                "pattern": "[@]|^$|^[1-9][0-9]*$"
            },   // POINTER
            caseStatus: {"type": ["null", {"enum": ["", "@", "1", "2", "3", "4", "5"]}]},    // SET
            caseType: {"type": ["null", {"enum": ["", "@", "1", "2", "3", "4"]}]},    // SET
            // OP/PRE-OP
            preopSkinInteg: {
                "type": ["string", "integer"],
                "pattern": "[@]|^$|^[1-9][0-9]*$"
            },	//POINTER
            toOrTranspDevice: {
                "type": ["string", "integer"],
                "pattern": "[@]|^$|^[1-9][0-9]*$"
            },	//POINTER
            hairRemovalBy: {
                "type": ["string", "integer"],
                "pattern": "[@]|^$|^[1-9][0-9]*$"
            },	//POINTER
            restraintPositionAids: {
                "type": ["string", "integer", "array"],
                "pattern": "[@]|^$|^[1-9][0-9]*$"
            },	//POINTER
            skinPrepAgent: {
                "type": ["string", "integer"],
                "pattern": "[@]|^$|^[1-9][0-9]*$"
            },	//POINTER
            skinPrepperOne: {
                "type": ["string", "integer"],
                "pattern": "[@]|^$|^[1-9][0-9]*$"
            },	//POINTER
            preopMood: {
                "type": ["string", "integer"],
                "pattern": "[@]|^$|^[1-9][0-9]*$"
            },	//POINTER
            preopConscious: {
                "type": ["string", "integer"],
                "pattern": "[@]|^$|^[1-9][0-9]*$"
            },	//POINTER
            timePatientInHoldArea: {"type": ["string", "null", "NaN"]},   // DATE
            timePatientInOR: {"type": ["string", "null", "NaN"]},   // DATE
            timeOperationBegan: {"type": ["string", "null", "NaN"]},   // DATE
            timeOperationEnds: {"type": ["string", "null", "NaN"]},   // DATE
            timePatientOutOR: {"type": ["string", "null", "NaN"]},   // DATE
            bloodLoss: {
                "type": ["string", "integer"],
                "pattern": "[@]|^$|^[1-9][0-9]*$"
            },	//NUMBER
            totalUrineOutput: {
                "type": ["string", "integer"],
                "pattern": "[@]|^$|^[1-9][0-9]*$"
            },	//NUMBER
            opDisposition: {
                "type": ["string", "integer"],
                "pattern": "[@]|^$|^[1-9][0-9]*$"
            },	//POINTER
            electroGroundPosition: {
                "type": ["string", "integer"],
                "pattern": "[@]|^$|^[1-9][0-9]*$"
            },	//POINTER
            foleyCatheterSize: {
                "type": ["string", "integer"],
                "pattern": "[@]|^$|^[1-9][0-9]*$"
            },	//NUMBER
            foleyCatheterInsertedBy: {
                "type": ["string", "integer"],
                "pattern": "[@]|^$|^[1-9][0-9]*$"
            },	//POINTER
            postopSkinInteg: {
                "type": ["string", "integer"],
                "pattern": "[@]|^$|^[1-9][0-9]*$"
            },	//POINTER
            postopMood: {
                "type": ["string", "integer"],
                "pattern": "[@]|^$|^[1-9][0-9]*$"
            },	//POINTER
            postopConscious: {
                "type": ["string", "integer"],
                "pattern": "[@]|^$|^[1-9][0-9]*$"
            },	//POINTER
            packing: {"type": ["null", {"enum": ["", "@", "V", "I", "P", "B", "D", "O", "N"]}]},    // SET
            patientEduAssessment: {"type": ["null", {"enum": ["", "@", "Y", "N", "I", "U"]}]},    // SET
            woundClassifciation: {"type": ["null", {"enum": ["", "@", "U", "C", "CC", "D", "I"]}]},    // SET
            skinPrepperTwo: {
                "type": ["string", "integer"],
                "pattern": "[@]|^$|^[1-9][0-9]*$"
            },	//POINTER
            skinPrepperThree: {
                "type": ["string", "integer"],
                "pattern": "[@]|^$|^[1-9][0-9]*$"
            },	//POINTER
            secondSkinPrepAgent: {
                "type": ["string", "integer"],
                "pattern": "[@]|^$|^[1-9][0-9]*$"
            },	//POINTER
            tubesAndDrains: {"type": ["string", "null"]},	//FREE TEXT
            fromeCareAreaTranspDevice: {
                "type": ["string", "integer"],
                "pattern": "[@]|^$|^[1-9][0-9]*$"
            },	//POINTER
            principalPostOpDiag: {"type": ["string", "null"]},	//FREE TEXT
            dressing: {"type": ["string", "null"]},	//FREE TEXT
            gastricOutput: {
                "type": ["string", "integer"],
                "pattern": "[@]|^$|^[1-9][0-9]*$"
            },	//NUMBER
            height: {"type": ["string", "null"]},	//FREE TEXT
            heightMeasureDate: {"type": ["string", "null", "NaN"]},   // DATE
            weight: {"type": ["string", "null"]},	//FREE TEXT
            hairRemovalMethod: {"type": ["null", {"enum": ["", "@", "C", "D", "N", "P", "S", "U", "O"]}]},    // SET
            hariRemovalComments	: {"type": ["string", "null"]},	//WORD-PROCESSING
            iuContamination: {
                "type": ["string", "integer"],
                "pattern": "[@]|^$|^[1-9][0-9]*$"
            },	//NUMBER
            iuSPSOrMgmt: {
                "type": ["string", "integer"],
                "pattern": "[@]|^$|^[1-9][0-9]*$"
            },	//NUMBER
            iuEmergencyCase: {
                "type": ["string", "integer"],
                "pattern": "[@]|^$|^[1-9][0-9]*$"
            },	//NUMBER
            iuNoBetterOption: {
                "type": ["string", "integer"],
                "pattern": "[@]|^$|^[1-9][0-9]*$"
            },	//NUMBER
            iuLoanerInstrument: {
                "type": ["string", "integer"],
                "pattern": "[@]|^$|^[1-9][0-9]*$"
            },	//NUMBER
            iuDecontamination: {
                "type": ["string", "integer"],
                "pattern": "[@]|^$|^[1-9][0-9]*$"
            },	//NUMBER
            reportGivenTo: {
                "type": ["string", "integer"],
                "pattern": "[@]|^$|^[1-9][0-9]*$"
            },	//POINTER
            // RISK ASSESSMENT
            general: {"type": ["null", {"enum": ["", "@","Y", "N"]}]},    // SET
            diabetesMellitusChronic: {"type": ["null", {"enum": ["", "@", "1", "2", "3", "4", 1, 2, 3, 4]}]},    // SET
            diabetesMellitusPreopMgmt: {"type": ["null", {"enum": ["", "@", "1", "2", "3", "4", 1, 2, 3, 4]}]},    // SET
            tobaccoUse: {"type": ["null", {"enum": ["", "@", "1", "2", "3", "4","5", 1, 2, 3, 4, 5]}]},    // SET
            tobaccoUseTimeframe: {"type": ["null", {"enum": ["", "@", "1", "2", "3", "NA", 1, 2, 3]}]},    // SET
            etohGTTwoDrinksPerDay: {"type": ["null", {"enum": ["", "@","Y", "N", "NS"]}]},    // SET
            positiveDrugScreening: {"type": ["null", {"enum": ["", "@","Y", "N", "NA", "1", "2", "3", "4", 1, 2, 3, 4]}]},    // SET
            dyspnea: {"type": ["null", {"enum": ["", "@", "1", "2", "3", "NS", 1, 2, 3]}]},    // SET
            preopSleepApnea: {"type": ["null", {"enum": ["", "@", "1", "2", "3", 1, 2, 3]}]},    // SET
            dnrStatus: {"type": ["null", {"enum": ["", "@","Y", "N", "NS"]}]},    // SET
            preopFunctHealthStatus: {"type": ["null", {"enum": ["", "@", "1", "2", "3", "4", 1, 2, 3, 4]}]},    // SET
            residence30DaysPreop: {"type": ["null", {"enum": ["", "@", "1", "2", "3", "4", "5", 1, 2, 3, 4, 5]}]},    // SET
            ambulationDevicePreop: {"type": ["null", {"enum": ["", "@", "1", "2", "3", "4", 1, 2, 3, 4]}]},    // SET
            homeless: {"type": ["null", {"enum": ["", "@","Y", "N", "NS"]}]},    // SET
            pulmonary: {"type": ["null", {"enum": ["", "@","Y", "N", "NS"]}]},    // SET
            ventilatorDependent: {"type": ["null", {"enum": ["", "@","Y", "N", "NS"]}]},    // SET
            historyOfCOPD: {"type": ["null", {"enum": ["", "@","Y", "N"]}]},    // SET
            currentPneumonia: {"type": ["null", {"enum": ["", "@","Y", "N", "NS"]}]},    // SET
            hepatobiliary: {"type": ["null", {"enum": ["", "@","Y", "N", "NS"]}]},    // SET
            ascites: {"type": ["null", {"enum": ["", "@","Y", "N", "NS"]}]},    // SET
            gastrointestinal: {"type": ["null", {"enum": ["", "@","Y", "N", "NS"]}]},    // SET
            esophagealVarices: {"type": ["null", {"enum": ["", "@","Y", "N", "NS"]}]},    // SET
            cardiac: {"type": ["null", {"enum": ["", "@","Y", "N", "NS"]}]},    // SET
            congestiveHeartFailurePreop: {"type": ["null", {"enum": ["", "@", "0", "1", "2", "3", "4", "5", "6", 0, 1, 2, 3, 4, 5, 6]}]},    // SET
            priorMI: {"type": ["null", {"enum": ["", "@", "0", "1", "2", "3", "4", "5", 0, 1, 2, 3, 4, 5]}]},    // SET
            pci: {"type": ["null", {"enum": ["", "@", "0", "1", "2", "3", "12", "72", "7", 0, 1, 2, 3, 12, 72, 7]}]},    // SET
            priorHearSurgery: {"type": ["string", "null"]},	//FREE TEXT
            anginaSeverity: {"type": ["null", {"enum": ["", "@", "N", "I", "II", "III", "IV", "U"]}]},    // SET
            anginaTimeframe: {"type": ["null", {"enum": ["", "@", "1", "2", "3", "4", 1, 2, 3, 4]}]},    // SET
            hypertension: {"type": ["null", {"enum": ["", "@","Y", "N"]}]},    // SET
            priorSurgSameOpField: {"type": ["null", {"enum": ["", "@", "0", "1", "2", "3", "4", "5", "6", 0, 1, 2, 3, 4, 5, 6]}]},    // SET
            hxRadRxPlannedSurgField: {"type": ["null", {"enum": ["", "@","Y", "N"]}]},    // SET
            cvdRepair: {"type": ["null", {"enum": ["", "@", "1", "2", "3", "0", 1, 2, 3, 0]}]},    // SET
            donorSerologyHIV: {"type": ["null", {"enum": ["", "@","Y", "N", "NA"]}]},    // SET
            vascular: {"type": ["null", {"enum": ["", "@","Y", "N", "NS"]}]},    // SET
            peripheralArterialDisease: {"type": ["null", {"enum": ["", "@","Y", "N", "1", "2", "3", "4", 1, 2, 3, 4]}]},    // SET
            restPainGangrene: {"type": ["null", {"enum": ["", "@","Y", "N", "NS"]}]},    // SET
            renal: {"type": ["null", {"enum": ["", "@","Y", "N", "NS"]}]},    // SET
            renalFailure: {"type": ["null", {"enum": ["", "@","Y", "N", "NS"]}]},    // SET
            onDialysis: {"type": ["null", {"enum": ["", "@","Y", "N", "NS"]}]},    // SET
            centralNervSystemIllness: {"type": ["null", {"enum": ["", "@","Y", "N", "NS"]}]},    // SET
            impairedSensorium: {"type": ["null", {"enum": ["", "@","Y", "N", "NS"]}]},    // SET
            coma: {"type": ["null", {"enum": ["", "@","Y", "N", "NS"]}]},    // SET
            hemiplegiaHemiparesis: {"type": ["null", {"enum": ["", "@","Y", "N", "NS"]}]},    // SET
            historyOfCVD: {"type": ["null", {"enum": ["", "@", "1", "2", "3", "0", 1, 2, 3, 0]}]},    // SET
            tumorInvolvingCNS: {"type": ["null", {"enum": ["", "@","Y", "N", "NS"]}]},    // SET
            impairedCognitiveFunction: {"type": ["null", {"enum": ["", "@", "1", "2", "3", "0", 1, 2, 3, 0]}]},    // SET
            nutritionalImmuneOther: {"type": ["null", {"enum": ["", "@","Y", "N", "NS"]}]},    // SET
            disseminatedCancer: {"type": ["null", {"enum": ["", "@","Y", "N", "NS"]}]},    // SET
            openWound: {"type": ["null", {"enum": ["", "@","Y", "N", "NS"]}]},    // SET
            chronicSteroidUse: {"type": ["null", {"enum": ["", "@","Y", "N", "NS"]}]},    // SET
            tenPercDecrWeightLoss: {"type": ["null", {"enum": ["", "@","Y", "N", "NS"]}]},    // SET
            bleedingDisorders: {"type": ["null", {"enum": ["", "@","Y", "N", "NS"]}]},    // SET
            bleedingRiskDueToMed: {"type": ["null", {"enum": ["", "@", "1", "2", "3", "4", "Y", "N", 1, 2, 3, 4]}]},    // SET
            transfusionGTFourRBCUnits: {"type": ["null", {"enum": ["", "@","Y", "N", "NS"]}]},    // SET
            chemoForMaligLastNinety: {"type": ["null", {"enum": ["", "@", "1", "2", "3", 1, 2, 3]}]},    // SET
            radiotherapyLastNinety: {"type": ["null", {"enum": ["", "@","Y", "N", "NS"]}]},    // SET
            preopSepsis: {"type": ["null", {"enum": ["", "@", "Y", "N", "NS", "1", "2", "3", 1, 2, 3]}]},    // SET
            pregnancy: {"type": ["null", {"enum": ["", "@","Y", "NO", "NA"]}]},   // SET
            assessmentType: {"type": ["null", {"enum": ["", "@","C", "N"]}]}    // SET
        }
    }
}


module.exports = validator;