/**
 * TemplateCase model
 * @author atignola
 */

// required imports to define schema
const mongoose = require('mongoose');
const Schema = mongoose.Schema;

const TemplateCaseSchema = new Schema({
    //ien : String,
    caseCreateDate : String,
    dateOfOperation : String,
    principalProcedure : String,
    generalComments : String,
    otherProcedures : String,
    plannedPostopCare : String,
    plannedPrincOpProcCPT : String,
    operationIndications : String,
    briefClinHistory : String,
    procedureLaterality : String,
    caseScheduleType : String,
    surgerySpecialty : String,
    primarySurgeon : String,
    otherPreopDiagnosis : String,
    referringPhysician : String,
    principalPreOpDiagnosis : String,
    prinPreOpDiagICD : String,
    surgeryPosition : String,
    principalPreOpICD : String,
    palliation : String,
    specialEquipment : String,
    plannedProsthImplant : String
});

TemplateCaseSchema.path('principalProcedure').required(true, 'The Principal Procedure cannot be blank');

mongoose.model('TemplateCase', TemplateCaseSchema, "templateCase");