/**
 * SSLQI Reservation
 */
const mongoose = require('mongoose');
const Schema = mongoose.Schema;

const SSLQIReservation = new Schema({
    vistaId: Number,
    classification: String,
    room: String,
    caseId: Number,
    requester: String,
    startDT: Date,
    endDT: Date,
    comments: String
});

SSLQIReservation.index({vistaId: 1, classification: 1}, {unique: true});
SSLQIReservation.path('vistaId').required(true, 'vistaId can not be empty');
SSLQIReservation.path('classification').required(true, 'classification can not be empty');
SSLQIReservation.path('startDT').required(true, 'Start date/time can not be empty');
SSLQIReservation.path('endDT').required(true, 'End date/time can not be empty');
SSLQIReservation.path('caseId').required(true, 'Case ID can not be empty');

mongoose.model('SSLQIReservation', SSLQIReservation, "sslqiReservation");