/**
 * SSLQI Release Request
 */
const mongoose = require('mongoose');
const Schema = mongoose.Schema;

const SSLQIReleaseRequest = new Schema({
    caseId: Number,
    requester: String,
    initialReservationId: String,
    startDT: String,
    endDT: String,
    releaseStatus: String,
    comments: String
});

SSLQIReleaseRequest.path('caseId').required(true, 'Case ID can not be empty');
SSLQIReleaseRequest.path('initialReservationId').required(true, 'Initial reservation ID can not be empty');

mongoose.model('SSLQIReleaseRequest', SSLQIReleaseRequest, "sslqiReleaseRequest");