/**
 * SSLQI
 */
const mongoose = require('mongoose');
const Schema = mongoose.Schema;

const SSLQI = new Schema({
    vistaId: Number,
    itemCategory: String,
    itemType: String,
    itemSpecialtyType: String,
    item: String,
    inventoryNumber: String,
    classification: String,
    itemLocationFacility: String,
    itemLocationRoom: String,
    itemStatus: String,
    itemTypeQuantity: String,
    size: String,
    itemUsage: String,
    specialty: Array,  // Lives in VistA
    manufacturer: String,  // Lives in VistA
    vendor: String,
    model: String,
    serialNumber: String,
    mobilityIndicator: String,
    roomNumber: String,
    reqRoomSize: String,
    shields: String,
    environmentalInformation: String,
    availability: String,
    blockedTimes: String,
    attributeTags: String,
    limitations: String,
    safetyMeasureThresholdMin: String,
    safetyMeasureThresholdMax: String,
    comments: String,
    poc: String
});

SSLQI.index({vistaId: 1, classification: 1}, {unique: true});
SSLQI.path('vistaId').required(true, 'vistaId can not be empty');
SSLQI.path('classification').required(true, 'classification can not be empty');

mongoose.model('SSLQI', SSLQI, "sslqi");