/**
 * Room Type Config
 */
const mongoose = require('mongoose');
const Schema = mongoose.Schema;

const SpecialtyRoomTypeMapping = new Schema({
    specialty : {
        type: String,
        index: true,
        unique: true
    },
    orNonOr: String,
    defaultRoom: Number
});

SpecialtyRoomTypeMapping.path('specialty').required(true, 'Specialty can not be empty');

mongoose.model('SpecialtyRoomTypeMapping', SpecialtyRoomTypeMapping, "specialtyRoomTypeMapping");

/*
 {
 "specialty":"99",
 "orNonOr": "O",
 "defaultRoom":""
 }

 */