/** schemas.js **/

schemas = {  
    user: {
        id: null,
        name: null,
        password: null
       },
    patient:{
    	dfn: null,
        name: null,
        gender: null,
        dob: null,
        age: null,
        ssn: null,
        maritalStatus: null,
        birthCity: null,
        birthState: null,
        provider: null,
        roomBed: null,
        currentRoom: null,
        addrStreet1: null,
        addrStreet2: null,
        addrStreet3: null,
        addrCity: null,
        addrState: null,
        addrZip: null,
        addrCounty: null,
        addrProvince: null,
        addrCountry: null,
        addrForeignPostCode: null,
        addrZipExt: null,
        resPhoneNum: null,
        workPhonNum: null,
        email: null,
        kName: null,
        kRelationship: null,
        kAddressPatientAddress: null,
        kStreet1: null,
        kStreet2: null,
        kStreet3: null,
        kCity: null,
        kState: null,
        kZip: null,
        kPhone: null,
        scYesNo: null,
        scAwardDate: null
    },
    cpt:{
        id: null,
        cptCode: null,
        name: null,
        cptCategory: null,
        source: null, // C=CPT, H=HCPCS, L=Local
        inactive: null  // 1=inactive
    },
    caseCancellationReason:{
        id: null,
        name: null,
        code: null,
        avoidable: null,
        inactive: null
    },
    case:{
        ien: null,
        patient: null,
        hospitalAdmissionStatus: null,
        serviceConnected: null,
        generalComments: null,
        princAnesthetist: null,
        anesthesiologistSupvr: null,
        otherProcedures: null,
        plannedPostopCare: null,
        caseCreateDate: null,
        cancelDate: null,
        primaryCancelReason: null,
        principalProcedure: null,
        plannedPrincOpProcCPT: null,
        operationIndications: null,
        briefClinHistory: null,
        procedureLaterality: null,
        cancelComments: null,
        cancelTimeframe: null,
        caseScheduleType: null,
        concurrentCase: null,
        dateOfOperation: null,
        procedureDate: null,
        nonOrFlag: null,
        orRoom: null,
        principalPreOpDiagnosis: null,
        reqAneTechnique: null,
        surgeryPosition: null,
        scheduledStartTime: null,
        scheduledEndTime: null,
        duration: null,
        caseType: null,
        caseStatus: null
    },
    // This model is used for the creation and editing of the data when calling RPC
    // schemas.fullCase = Object.assign(schemas.orCase, schemas.nonOrCase);
    fullCase:{
        ien: "",
        patient: "",
        hospitalAdmissionStatus: "",
        serviceConnected: "",
        associatedClinic: "",
        resSupCode: "",
        anesCareTimeBlock: "",
        generalComments: "",
        princAnesthetist: "",
        anesthesiologistSupvr: "",
        anesSuperviseCode: "",
        anesthesiaTechnique: "",
        otherProcedures: "",
        plannedPostopCare: "",
        otherPostopDiags: "",
        caseCreateDate: "",
        asaClass: "",
        cancelDate: "",
        primaryCancelReason: "",
        diagnosticTherapeutic: "",
        principalProcedure: "",
        plannedPrincOpProcCPT: "",
        principalDiagnosis: "",
        specimens: "",
        operationIndications: "",
        operativeFindings: "",
        briefClinHistory: "",
        plannedPrinDiagCode: "",
        location: "",
        procedureDate: "",
        procedureStartTime: "",
        procedureEndTime: "",
        provider: "",
        attendingProvider: "",
        medicalSpecialty: "",
        procedureOccurence: "",
        procedureLaterality: "",
        dictatedSummary: "",
        cancelComments: "",
        cancelTimeframe: "",
        caseScheduleType: "",
        concurrentCase: "",
        dateOfOperation: "",
        nonOrFlag: "",
        orRoom: "",
        principalPreOpDiagnosis: "",
        reqAneTechnique: "",
        surgeryPosition: "",
        plannedAdmissionStatus: "",
        caseScheduleOrder: "",
        surgerySpecialty: "",
        preOpInfection: "",
        primarySurgeon: "",
        firstAsst: "",
        secondAsst: "",
        attendingSurgeon: "",
        otherPreopDiagnosis: "",
        reqFrozSect: "",
        reqPreopXray: "",
        intraoperativeXrays: "",
        reqPhoto: "",
        reqBloodKind: "",
        referringPhysician: "",
        prinPreOpDiagICD: "",
        requestBloodAvailability: "",
        bloodProductInfo: "",
        preAdmissionTesting: "",
        palliation: "",
        specialEquipment: "",
        plannedProsthImplant: "",
        specialSupplies: "",
        specialInstruments: "",
        pharmacyItems: "",
        bloodTypeXmatch: "",
        scheduledEndTime: "",
        scheduledStartTime: "",
        spinalLevel: "",
        surgeryScheduler: "",
        caseStatus: "",
        caseType: "",
        //OP/PRE-OP
        preopSkinInteg: "",
        toOrTranspDevice: "",
        hairRemovalBy: "",
        restraintPositionAids: "",
        skinPrepAgent: "",
        skinPrepperOne: "",
        preopMood: "",
        preopConscious: "",
        timePatientInHoldArea: "",
        timePatientInOR: "",
        timeOperationBegan: "",
        timeOperationEnds: "",
        timePatientOutOR: "",
        bloodLoss: "",
        totalUrineOutput: "",
        opDisposition: "",
        electroGroundPosition: "",
        foleyCatheterSize: "",
        foleyCatheterInsertedBy: "",
        postopSkinInteg: "",
        postopMood: "",
        postopConscious: "",
        packing: "",
        patientEduAssessment: "",
        woundClassifciation: "",
        skinPrepperTwo: "",
        skinPrepperThree: "",
        secondSkinPrepAgent: "",
        tubesAndDrains: "",
        fromeCareAreaTranspDevice: "",
        principalPostOpDiag: "",
        dressing: "",
        gastricOutput: "",
        height: "",
        heightMeasureDate: "",
        weight: "",
        hairRemovalMethod: "",
        hariRemovalComments: "",
        iuContamination: "",
        iuSPSOrMgmt: "",
        iuEmergencyCase: "",
        iuNoBetterOption: "",
        iuLoanerInstrument: "",
        iuDecontamination: "",
        reportGivenTo: "",
        // Risk Assessment
         general: "",
         diabetesMellitusChronic: "",
         diabetesMellitusPreopMgmt: "",
         tobaccoUse: "",
         tobaccoUseTimeframe: "",
         etohGTTwoDrinksPerDay: "",
         positiveDrugScreening: "",
         dyspnea: "",
         preopSleepApnea: "",
         dnrStatus: "",
         preopFunctHealthStatus: "",
         residence30DaysPreop: "",
         ambulationDevicePreop: "",
         homeless: "",
         pulmonary: "",
         ventilatorDependent: "",
         historyOfCOPD: "",
         currentPneumonia: "",
         hepatobiliary: "",
         ascites: "",
         gastrointestinal: "",
         esophagealVarices: "",
         cardiac: "",
         congestiveHeartFailurePreop: "",
         priorMI: "",
         pci: "",
         priorHearSurgery: "",
         anginaSeverity: "",
         anginaTimeframe: "",
         hypertension: "",
         priorSurgSameOpField: "",
         hxRadRxPlannedSurgField: "",
         cvdRepair: "",
         donorSerologyHIV: "",
         vascular: "",
         peripheralArterialDisease: "",
         restPainGangrene: "",
         renal: "",
         renalFailure: "",
         onDialysis: "",
         centralNervSystemIllness: "",
         impairedSensorium: "",
         coma: "",
         hemiplegiaHemiparesis: "",
         historyOfCVD: "",
         tumorInvolvingCNS: "",
         impairedCognitiveFunction: "",
         nutritionalImmuneOther: "",
         disseminatedCancer: "",
         openWound: "",
         chronicSteroidUse: "",
         tenPercDecrWeightLoss: "",
         bleedingDisorders: "",
         bleedingRiskDueToMed: "",
         transfusionGTFourRBCUnits: "",
         chemoForMaligLastNinety: "",
         radiotherapyLastNinety: "",
         preopSepsis: "",
         pregnancy: ""
    },
    vistaConstants: {
        patient: "1.01",
        hospitalAdmissionStatus: "0.011",
        serviceConnected: "0.016",
        associatedClinic: "0.021",
        resSupCode: "0.166",
        anesCareTimeBlock: "0.213",
        generalComments: "0.28",
        princAnesthetist: "0.31",
        anesthesiologistSupvr: "0.34",
        anesSuperviseCode: "0.345",
        anesthesiaTechnique: "0.37",
        otherProcedures: "0.42",
        plannedPostopCare: "0.43",
        otherPostopDiags: "0.74",
        caseCreateDate: "1.098",
        asaClass: "1.13",
        cancelDate: "17",
        primaryCancelReason: "18",
        diagnosticTherapeutic: "20",
        principalProcedure: "26",
        plannedPrincOpProcCPT: "27",
        principalDiagnosis: "33",
        specimens: "49",
        operationIndications: "55",
        operativeFindings: "59",
        briefClinHistory: "60",
        plannedPrinDiagCode: "66",
        location: "119",
        procedureDate: "120",
        procedureStartTime: "121",
        procedureEndTime: "122",
        provider: "123",
        attendingProvider: "124",
        medicalSpecialty: "125",
        procedureOccurence: "126",
        procedureLaterality: "638",
        dictatedSummary: "1004",
        cancelComments: "19",
        cancelTimeframe: "17.5",
        caseScheduleType: "0.035",
        concurrentCase: "35",
        dateOfOperation: "0.09",
        nonOrFlag: "118",
        orRoom: "0.02",
        principalPreOpDiagnosis: "32",
        reqAneTechnique: "1.01",
        surgeryPosition: "65",
        patient: "0.01",
        plannedAdmissionStatus: "0.013",
        caseScheduleOrder: "0.037",
        surgerySpecialty: "0.04",
        preOpInfection: "0.05",
        primarySurgeon: "0.14",
        firstAsst: "0.15",
        secondAsst: "0.16",
        attendingSurgeon: "0.164",
        otherPreopDiagnosis: "0.72",
        reqFrozSect: "1.02",
        reqPreopXray: "1.03",
        intraoperativeXrays: "1.035",
        reqPhoto: "1.04",
        reqBloodKind: "1.05",
        referringPhysician: "23",
        prinPreOpDiagICD: "32.5",
        requestBloodAvailability: "38",
        bloodProductInfo: "40",
        preAdmissionTesting: "56",
        palliation: "661",
        specialEquipment: "680",
        plannedProsthImplant: "681",
        specialSupplies: "682",
        specialInstruments: "683",
        pharmacyItems: "684",
        bloodTypeXmatch: "0.993",
        scheduledEndTime: "11",
        scheduledStartTime: "10",
        spinalLevel: "136",
        surgeryScheduler: "1.099",
        caseStatus: "2006",
        caseType: "2007",
        preopSkinInteg: "0.07",
        toOrTranspDevice: "0.11",
        hairRemovalBy: "0.12",
        restraintPositionAids: "0.13",
        skinPrepAgent: "0.175",
        skinPrepperOne: "0.18",
        preopMood: "0.19",
        preopConscious: "0.196",
        timePatientInHoldArea: "0.203",
        timePatientInOR: "0.205",
        timeOperationBegan: "0.22",
        timeOperationEnds: "0.23",
        timePatientOutOR: "0.232",
        bloodLoss: "0.25",
        totalUrineOutput: "0.255",
        opDisposition: "0.46",
        electroGroundPosition: "0.55",
        foleyCatheterSize: "0.56",
        foleyCatheterInsertedBy: "0.57",
        postopSkinInteg: "0.76",
        postopMood: "0.81",
        postopConscious: "0.821",
        packing: "0.875",
        patientEduAssessment: "0.971",
        woundClassifciation: "1.09",
        skinPrepperTwo: "4",
        skinPrepperThree: "5",
        secondSkinPrepAgent: "8",
        tubesAndDrains: "22",
        fromeCareAreaTranspDevice: "25",
        principalPostOpDiag: "34",
        dressing: "41",
        gastricOutput: "62",
        height: "236",
        heightMeasureDate: "236.1",
        weight: "237",
        hairRemovalMethod: "506",
        hariRemovalComments: "508",
        iuContamination: "619",
        iuSPSOrMgmt: "620",
        iuEmergencyCase: "621",
        iuNoBetterOption: "622",
        iuLoanerInstrument: "623",
        iuDecontamination: "624",
        reportGivenTo: "639"
    }
}


module.exports = schemas;  