/**
Provider represents someone who 
is providing service to the 
@author rahulgokulnath
*/

const mongoose = require('mongoose');
const Schema = mongoose.Schema;

// validate time string
function validateTime(value){
	return /\d{2}:\d{2}/.test(value)
}

let day_of_week_validators = [
  {
    validator: function(array_val){
      return array_val.length;
    },
    msg: "Array must contain values between 1 and 7"
  },
  {
    // check values between 1 and 7
    validator: function(array_val){
      for(var i = 0; i < array_val.length; i++){
        let val = array_val[i];
        if(val < 1 || val > 7){
          return false;
        }  
      }     
      return true;
    },
    msg: "All array values must be a value between 1 and 7"
  },
  {
    // check for duplicate values
    validator: function(array_val){
      var sorted_arr = array_val.slice().sort();
      for(var i = 0; i < sorted_arr.length-1; i++){
        if(sorted_arr[i+1] == sorted_arr[i])
          return false;
      }
      return true;
    },
    msg: "Array values must be unique"
  }
]

const ProviderSchema = new Schema({
  ien: { 
  	type : Number,
  	required: true 
  	},
  work_times: [{
    start: { 
    	type : String,
    	validate: validateTime,
    	message: '{VALUE} is not a valid time in hh:mm format'
    },
    end: { 
    	type : String,
    	validate: validateTime,
    	message: '{VALUE} is not a valid time in hh:mm format' 
    },
    dow: [
      {
        type: Number,
        required: true,
        validate: day_of_week_validators
      }
    ]
  }]
});

mongoose.model('Provider', ProviderSchema);