/**
 * A simple Name-Description object model
 */

const mongoose = require('mongoose');
const Schema = mongoose.Schema;

const NameDescriptionSchema = new Schema({
    name: String,
    description: String,
    category:String
});

NameDescriptionSchema.index({name: 1, category: 1}, {unique: true});
NameDescriptionSchema.path('category').required(true, 'category can not be empty');
mongoose.model('NameDescription', NameDescriptionSchema, "nameDescription");
