'use strict';

const AbstractModel = require('./abstractmodel');
const Validator = require('jsonschema').Validator;
let v = new Validator();
const schemas = require("./schemas");
const validationSchemas = require("./validationSchemas");

/**
 Full Case Model represents a union of OR and Non-OR case fields
 used for calling case create and edit RPC in VistA
 */
module.exports = class FullCase extends AbstractModel {
    constructor(){
        super(schemas.fullCase);
        v.addSchema(validationSchemas.fullCase, "/FullCase");
    }

    validate(){
        return v.validate(this.sanitize(), '/FullCase');
    }

}