/**
 * Case Overtime
 */
const mongoose = require('mongoose');
const Schema = mongoose.Schema;

const ExtendedCaseSchema = new Schema({
    vistaId: {
        type :String,
        index: true,
        unique: true
    },
    estimatedOverTime: { type : Number, default : '', trim : true },
    affectedCases: [String]
});

ExtendedCaseSchema.path('vistaId').required(true, 'VistA ID can not be blank');

mongoose.model('ExtendedCase', ExtendedCaseSchema, "extendedCase");