/**
 * CPT Config model
 */

const mongoose = require('mongoose');
const Schema = mongoose.Schema;

const CPTConfigSchema = new Schema({
    cptCode : {
        type: String,
        index: true,
        unique: true
    },
    procedureCategory: String,
    siteDuration: Number,
    nationalDuration: Number,
    surgeonDurations: Array,
    specialtyDurations: Array,
    durationLastUpdated: Date,
    complexityLevel : String,
    siteId : String,
    comments: String
});

mongoose.model('CPTConfig', CPTConfigSchema, 'cptConfiguration');