const mongoose = require('mongoose');
const Schema = mongoose.Schema;

const AuditSchema = new Schema({
    dateTime: Date,
    transactionType: String,  //  CREATE, UPDATE
    endpoint: String, //  PATIENT, PLACEHOLDER_CASE, REQUESTED_CASE, SCHEDULED_CASE, OTHER
    vistaId: Number,      //  The unique identifier assigned in MUMPS (this may not exist for all objects)
    mongoId: String,
    content: String,
    username: String
});

AuditSchema.path('dateTime').required(true, 'Date-Time cannot be null');
AuditSchema.path('transactionType').required(true, 'Transaction Type cannot be null');
AuditSchema.path('endpoint').required(true, 'Endpoint cannot be null');
AuditSchema.path('content').required(true, 'Content cannot be null');
AuditSchema.path('username').required(true, 'Username cannot be null');


mongoose.model('Audit', AuditSchema, "audit");