'use strict';
const cptConfigService = require("../services/cnf/cptConfig");
const cptService = require("../services/rpc/cpt");
const vista = require("../../lib/rpcvista/vista_surgery_services");
const errorHandler = require("../common/errorHandler");

/**
 *
 * @param loginOptions
 */
exports.getCPTDurationReportData = function(loginOptions, data, callback){

    cptConfigService.getDurationsForReport(data, function (error, result){
        if (error){
            console.log("ERROR: " + error);
            callback(error, null);
        }
        else if (result === undefined || result === null || result === ""){
            callback(errorHandler.notFound("No CPTConfiguration found."), null);
        }
        else {
            callback(null, result);
        }
    });
}