'use strict';
const cptConfigService = require("../services/cnf/cptConfig");
const cptService = require("../services/rpc/cpt");
const vista = require("../../lib/rpcvista/vista_surgery_services");
const Case = require("../model/case");
const FullCase = require("../model/fullCase");


/**
 * Checks to see if the  the CPT Durations in the DB need
 * to be updated and updates if need be.
 * @param loginOptions
 */
exports.checkCPTDurations = function(loginOptions){
    console.log("Entering checkCPTDurations ...");
    let today = new Date();
    let i, x, updateDate, difference, property, temp, update = false;

    // Get last update date
    cptConfigService.getAllCPTConfigDurationDates(function (error, dates){
        if (error){
            console.log("ERROR: " + error);
        }
        else {
            if (dates !== undefined && dates.length > 0) {
                // Iterate through dates
                for (i = 0, x = dates.length; i < x; i++){
                    // Check if CPT durations were updated within last quarter
                    updateDate = new Date(dates[i]);
                    difference = (today - updateDate) / 1000 / 60 / 60;
                    // Is difference greater than 1/4 of year (in hours)
                    if (difference > 2190){
                        update = true;
                        break;
                    }
                }

                if (update){
                    // Update CPT Durations
                    mongoose.connection.db.dropCollection('cptConfiguration', function(err, result){
                        if (!err){
                            updateCPTDurations(loginOptions);
                        }
                    })
                }
            }
            else if (dates !== undefined && dates.length === 0){
                updateCPTDurations(loginOptions);
            }
            else{
                console.log("no data in mongo, update");
            }
        }
    });
}

/**
 * Updates the calculated CPT Durations in Mongo.
 * @param loginOptions
 */
 exports.updateCPTDurations = function(loginOptions){
    // Get Surgery Duration Averages by CPT
    console.log("Entering updateCPTDurations ...");
    cptService.getCPTDurations(loginOptions, function(err, cptDurations){

        let temp;
        for (let property in cptDurations){
            temp = cptDurations[property];
            if (temp !== undefined ){ //&& Object.prototype.toString.call(temp) == '[object Array]' && temp.length > 0){

                cptConfigService.updateCPTDuration(temp, property);
            }
        }
        console.log("SUCCESS");
    })
}

/**
 * Updates the calculated CPT Durations in Mongo for specific criteria.
 * @param loginOptions
 * @param critieria - the criteria to filter on [CPT, CPT-SPECIALTY, CPT-PRIMARY SURGEON]
 */
exports.updateSpecificCPTDurations = function(loginOptions, criteria, callback){
    // Get Surgery Duration Averages by CPT
    console.log("Entering updateSpecificCPTDurations ...");
    cptService.getCPTDurations(loginOptions, criteria, function(err, cptDurations){

        let temp;
        for (let property in cptDurations){
            temp = cptDurations[property];
            if (temp !== undefined ){ //&& Object.prototype.toString.call(temp) == '[object Array]' && temp.length > 0){

                cptConfigService.updateCPTDuration(temp, property);
            }
        }
        callback(null, "SUCCESS");
    })
}