/**
Card Controller
@author gefunk
*/
const mongoose = require('mongoose');
// note the import of the mongoose model
const Card = mongoose.model('Card');

// create new
exports.create = function(card_data, response){	
	const card = new Card(card_data);
	// save function, will create a new record in the card collection in mongo
	card.save(function(err){
		if(err) {console.log(err);response.json( err);}
		response.json(card); 
	});
}

/**
Function Find all
*/
exports.findAll = function(response){
	// empty find {} will return all
	Card.find({}, function(err, docs){
		if(!err){
			// response is the HTTP response sent in by the routes.js file
			response.json(docs);
		} else {
			console.log(err);
			response.json(err);
		}
	});
}

/**
Delete Employee
*/
exports.delete = function(id, response){
	// findByIdAndRemove is just one of the many find functions in mongoose
	Card.findByIdAndRemove(id, function(err){
		if(!err) response.json({'success': true});
		else response.json(err);
	});
}

exports.findById = function(id, response){
	// another find function in mongoose
	Card.findById(id, function (err, doc) {
  		if(!err) response.json(doc);
		else response.json(err);
	}); 
}